package com.liveperson.messaging.commands.tasks;

import android.text.TextUtils;

import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.network.http.AgentProfileRequest;

/**
 * Created by Ilya Gazman on 11/16/2015.
 * <p/>
 * Base connection task to obtain user data
 */
public class GetAgentUserTask extends BaseAmsSocketConnectionTask {

    private static final String TAG = "GetAgentUserTask";
    private final Messaging mController;

    public GetAgentUserTask(Messaging controller) {
        mController = controller;
    }

    @Override
    public void execute() {

        boolean isAgentDetailsUpdated = mController.mConnectionController.getConnection(mBrandId).isAgentDetailsUpdated();
        if (isAgentDetailsUpdated) {
            mCallback.onTaskSuccess();
        } else {
            LPLog.INSTANCE.i(TAG, "Running get updated user task...");

            Dialog activeDialog = mController.amsDialogs.getActiveDialog();
            if (activeDialog != null && activeDialog.isOpen()) {
                String assignedAgentServerId = activeDialog.getAssignedAgentId();
                if (TextUtils.isEmpty(assignedAgentServerId)) {
                    //no assigned agent
                    finishTaskSuccessfully("No assigned agent for current conversation");
                } else {
                    new AgentProfileRequest(mController, activeDialog.getTargetId(), assignedAgentServerId, activeDialog.getDialogId(), false).execute();
                    finishTaskSuccessfully("Bringing assigned agent details...");
                }
            } else {
                finishTaskSuccessfully("No active conversation");
            }
        }
    }

    private void finishTaskSuccessfully(String log) {
        LPLog.INSTANCE.d(TAG, log);
        mController.mConnectionController.getConnection(mBrandId).setAgentDetailsUpdated(true);
        mCallback.onTaskSuccess();
    }
}
