/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import android.text.TextUtils;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionTask;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.network.http.AgentProfileRequest;

public class GetAgentUserTask
extends BaseAmsSocketConnectionTask {
    private static final String TAG = "GetAgentUserTask";
    private final Messaging mController;

    public GetAgentUserTask(Messaging controller) {
        this.mController = controller;
    }

    public void execute() {
        boolean isAgentDetailsUpdated = this.mController.mConnectionController.getConnection(this.mBrandId).isAgentDetailsUpdated();
        if (isAgentDetailsUpdated) {
            this.mCallback.onTaskSuccess();
        } else {
            LPLog.INSTANCE.i(TAG, "Running get updated user task...");
            Dialog activeDialog = this.mController.amsDialogs.getActiveDialog();
            if (activeDialog != null && activeDialog.isOpen()) {
                String assignedAgentServerId = activeDialog.getAssignedAgentId();
                if (TextUtils.isEmpty((CharSequence)assignedAgentServerId)) {
                    this.finishTaskSuccessfully("No assigned agent for current conversation");
                } else {
                    new AgentProfileRequest(this.mController, activeDialog.getTargetId(), assignedAgentServerId, activeDialog.getDialogId(), false).execute();
                    this.finishTaskSuccessfully("Bringing assigned agent details...");
                }
            } else {
                this.finishTaskSuccessfully("No active conversation");
            }
        }
    }

    private void finishTaskSuccessfully(String log) {
        LPLog.INSTANCE.d(TAG, log);
        this.mController.mConnectionController.getConnection(this.mBrandId).setAgentDetailsUpdated(true);
        this.mCallback.onTaskSuccess();
    }
}

