package com.liveperson.messaging.offline.api

import com.liveperson.infra.ICallback
import com.liveperson.infra.model.LPWelcomeMessage
import com.liveperson.messaging.model.FullMessageRow

interface OfflineMessagesController {

    /**
     * The currently active brand id
     */
    val currentBrandId: String

    /**
     * Flag to check if offline messaging is enabled
     */
    val isOfflineModeEnabled: Boolean

    /**
     * Flag to check if offline welcome message is enabled
     */
    val isOfflineWelcomeMessageEnabled: Boolean

    /**
     * Configuration for the behavior of a PCS dialog when offline messaging is enabled
     */
    val offlineModePCSBehavior: Int

    /**
     * Flag to check if there already is a subscription to the currently active dialog
     */
    var isSubscribedToActiveDialog: Boolean

    /**
     * Flag to check if there already is a subscription to the currently active dialog
     */
    var isFullySynced: Boolean

    /**
     * Method used for trying to send a message that was created as an offline message
     * @param message the message as [FullMessageRow] object
     */
    fun sendOfflineMessage(message: FullMessageRow)

    /**
     * Method used for resolving the currently active dialog
     * @param dialogId the id of the dialog to be resolved
     * @param callback the callback to be used when the request succeeds or fails
     */
    fun resolveActiveDialog(dialogId: String, callback: ICallback<Int, Exception>?)

    /**
     * Method used for sending a new conversation request
     * @param requestId the id of the request to be sent
     */
    fun sendNewConversationRequest(requestId: Long)

    /**
     * Method used for showing an offline welcome message
     * @param brandId the id of the brand
     * @param dialogId active dialog id
     * @param welcomeMessage the welcome message to show in offline mode
     */
    fun showOfflineWelcomeMessage(
        brandId: String,
        dialogId: String,
        welcomeMessage: LPWelcomeMessage
    )
}