package com.liveperson.messaging.wm.core.exceptions

/**
 * Throws exception for object which type is not supported.
 *
 * @param any object with unsupported type.
 */
internal fun throwTypeErrorOf(any: Any?): Nothing = throw UnsupportedTypeException(
    "Type of ${any?.javaClass} is not supported"
)

/**
 * Throws unsupported type exception with provided message.
 *
 * @param message of UnsupportedTypeException.
 */
internal fun throwTypeError(message: String): Nothing = throw UnsupportedTypeException(message)