/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.response.model;

import android.text.TextUtils;
import com.liveperson.api.exception.BadConversationException;
import com.liveperson.api.response.model.ConversationUMSDetails;
import org.json.JSONException;
import org.json.JSONObject;

public class Result {
    public String conversationId;
    public long effectiveTTR;
    public ConversationUMSDetails conversationDetails;

    public Result(JSONObject jsonObject) throws JSONException, BadConversationException {
        this.conversationId = jsonObject.optString("convId");
        if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
            throw new BadConversationException("no conversation id");
        }
        this.conversationDetails = null;
        JSONObject conversationDetailsObj = jsonObject.optJSONObject("conversationDetails");
        if (conversationDetailsObj != null) {
            this.conversationDetails = new ConversationUMSDetails(conversationDetailsObj, this.conversationId);
            this.effectiveTTR = 0L;
        }
    }

    public String toString() {
        return "{ conversationId: " + this.conversationId + ", conversationDetails: " + this.conversationDetails + " }";
    }
}

