/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import android.content.Context;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.network.http.requests.CSDSRequest;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.model.AmsConnectionAnalytics;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/liveperson/messaging/commands/tasks/CsdsTask;", "Lcom/liveperson/messaging/commands/tasks/BaseAmsAccountConnectionTask;", "context", "Landroid/content/Context;", "accountsController", "Lcom/liveperson/messaging/controller/AccountsController;", "brandId", "", "(Landroid/content/Context;Lcom/liveperson/messaging/controller/AccountsController;Ljava/lang/String;)V", "csdsDomain", "mAccountsController", "execute", "", "getName", "Companion", "messaging_release"})
public final class CsdsTask
extends BaseAmsAccountConnectionTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String csdsDomain;
    @NotNull
    private final AccountsController mAccountsController;
    @NotNull
    private static final String TAG = "CsdsTask";

    public CsdsTask(@NotNull Context context, @NotNull AccountsController accountsController, @NotNull String brandId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accountsController, (String)"accountsController");
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        this.csdsDomain = StringsKt.startsWith$default((String)brandId, (String)"qa", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)brandId, (String)"le", (boolean)false, (int)2, null) ? context.getResources().getString(R.string.csds_qa_url) : context.getResources().getString(R.string.csds_url);
        this.mAccountsController = accountsController;
    }

    public void execute() {
        LPLog.INSTANCE.d(TAG, "Running CSDS task...");
        AmsConnectionAnalytics.csdsTaskStart();
        List<String> certificates = this.mAccountsController.getCertificatePinningKeys(this.mBrandId);
        new CSDSRequest(this.csdsDomain, this.mBrandId, certificates, (ICallback)new ICallback<HashMap<String, String>, Exception>(this){
            final /* synthetic */ CsdsTask this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@Nullable HashMap<String, String> cSDSUrls) {
                if (CsdsTask.access$getMAccountsController$p(this.this$0).setCSDSMap(this.this$0.mBrandId, cSDSUrls)) {
                    LPLog.INSTANCE.d("CsdsTask", "onSuccess: One of the CSDS values had changed. Return error");
                    AmsConnectionAnalytics.csdsTaskEnd();
                    this.this$0.mCallback.onTaskError(TaskType.CSDS, LpError.CSDS, new Exception("New CSDS values were set."));
                    return;
                }
                AmsConnectionAnalytics.csdsTaskEnd();
                this.this$0.mCallback.onTaskSuccess();
            }

            public void onError(@Nullable Exception e) {
                if (e instanceof SSLPeerUnverifiedException) {
                    this.this$0.mCallback.onTaskError(TaskType.INVALID_CERTIFICATE, LpError.INVALID_CERTIFICATE, e);
                } else {
                    this.this$0.mCallback.onTaskError(TaskType.CSDS, LpError.CSDS, e);
                }
            }
        }).execute();
    }

    @Override
    @NotNull
    public String getName() {
        return TAG;
    }

    public static final /* synthetic */ AccountsController access$getMAccountsController$p(CsdsTask $this) {
        return $this.mAccountsController;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/messaging/commands/tasks/CsdsTask$Companion;", "", "()V", "TAG", "", "messaging_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

