/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket.requests;

import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.PublishEvent;
import com.liveperson.infra.model.types.ChatState;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import org.json.JSONException;
import org.json.JSONObject;

public class ChatStateChangeRequest
extends BaseAMSSocketRequest<PublishEvent.Response, ChatStateChangeRequest> {
    private static final String TAG = "ChatStateChangeRequest";
    private String mDialogId;
    private String mConversationId;
    private PublishEvent.Type mType = PublishEvent.Type.ChatStateEvent;
    private ChatState mState;

    public ChatStateChangeRequest(String socketUrl, String dialogId, String conversationId, ChatState state) {
        super(socketUrl);
        this.mDialogId = dialogId;
        this.mConversationId = conversationId;
        this.mState = state;
    }

    protected String getData() {
        return new PublishEvent(this.mDialogId, this.mConversationId, this.mType, this.mState).toJsonString(this.getRequestId());
    }

    protected String getRequestName() {
        return TAG;
    }

    protected BaseResponseHandler<PublishEvent.Response, ChatStateChangeRequest> getResponseHandler() {
        return new BaseResponseHandler<PublishEvent.Response, ChatStateChangeRequest>(){

            public String getAPIResponseType() {
                return "ms.PublishEventResponse";
            }

            protected PublishEvent.Response parse(JSONObject jsonObject) throws JSONException {
                return new PublishEvent.Response(jsonObject);
            }

            protected boolean handle(PublishEvent.Response response) {
                return true;
            }
        };
    }
}

