package com.liveperson.api.request;

import com.liveperson.api.response.AbstractResponse;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Purpose of this class is to reach out SocketHandler to send pending messages
 */
public class PendingMessagesRequest extends AbstractRequest {

    public static final String GENERAL_TYPE = "GeneralType";

    public PendingMessagesRequest() {
        super();
    }

    @Override
    public String getMessageType() {
        return GENERAL_TYPE;
    }

    @Override
    protected void toJson(JSONObject json) throws JSONException {
    }

    public static class Response extends AbstractResponse<Response.Body> {
        public Body body = new Body();

        public Response(JSONObject obj) throws JSONException {
            super(obj);
        }

        @Override
        public Response.Body getBody() {
            return body;
        }

        public class Body {
        }
    }
}
