/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.response.model;

public enum ContentType {
    text_html("text/html"),
    text_plain("text/plain"),
    text_structured_content("text/structured-content"),
    hosted_file("hosted/file"),
    application_json("application/json"),
    forms_secure_invitation("forms/secure-invitation"),
    forms_secure_submission("forms/secure-submission");

    private String text;

    private ContentType(String text) {
        this.text = text;
    }

    public static ContentType fromString(String text) throws IllegalArgumentException {
        if (text != null) {
            for (ContentType b : ContentType.values()) {
                if (!text.equalsIgnoreCase(b.text)) continue;
                return b;
            }
        }
        throw new IllegalArgumentException("No constant with text " + text + " found");
    }

    public String getText() {
        return this.text;
    }

    public boolean isFile() {
        return this == hosted_file;
    }

    public boolean isSimpleText() {
        return this == text_plain;
    }

    public boolean isHtml() {
        return this == text_html;
    }

    public boolean isFormInvitation() {
        return this == forms_secure_invitation;
    }

    public boolean isFormSubmission() {
        return this == forms_secure_submission;
    }
}

