package com.liveperson.messaging.cache

import com.liveperson.messaging.model.Dialog

interface DialogsCacheProvider {

    /**
     * Get dialog from cache by dialog id
     * @param dialogId the dialog id
     * @return the cached dialog or null if no dialog with this id could be found
     */
    fun getDialogById(dialogId: String?): Dialog?

    /**
     * Get the current active dialog from cache
     * @return the current cached active dialog or null if it doesn't exist
     */
    fun getActiveDialog(): Dialog?

    /**
     * Add a dialog to the cache
     * @param dialog the dialog to cache
     */
    fun cacheDialog(dialog: Dialog)

    /**
     * Remove a dialog from cache
     * @param targetId the target id
     * @param dialogId the id of the dialog to be removed
     */
    fun removeDialogFromCache(targetId: String, dialogId: String)
}
