package com.liveperson.messaging.offline.api

import androidx.annotation.WorkerThread
import com.liveperson.messaging.model.Dialog


interface OfflineDialogRepository {

    /**
     * Get the currently active dialog from cache
     */
    val cachedActiveDialog: Dialog?

    /**
     * Method used for getting the offline dialog from cache or from the database, or for
     * creating one in case it doesn't exist yet.
     * @param targetId the target id
     * @param brandId the brand id
     * @param conversationId the conversation id
     * @param requestId the request id
     * @return the stored offline dialog or a newly created one
     */
    @WorkerThread
    fun getOrCreateOfflineDialog(
        targetId: String,
        brandId: String,
        conversationId: String,
        requestId: Long
    ): Dialog

    /**
     * Method used for deleting the offline dialog from the database and cache.
     * @param targetId the target id
     */
    @WorkerThread
    fun clearOfflineDialog(targetId: String)

    /**
     * Method used for retrieving the current real active dialog from the database, if available.
     * @param brandId the brand id
     * @return the current real active dialog, if available
     */
    @WorkerThread
    fun queryRealActiveDialog(brandId: String): Dialog?
}
