/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.http;

import android.net.Uri;
import com.liveperson.api.response.model.QueryParams;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.body.HttpImageRequestBody;
import com.liveperson.infra.network.http.body.HttpRequestBody;
import com.liveperson.infra.network.http.request.HttpPutRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.infra.otel.LPTraceType;
import java.util.List;

public class UploadFileRequest
implements Command {
    private static final String TAG = "UploadFileRequest";
    private String mRelativePath;
    private QueryParams mQueryParams;
    private ICallback<Object, Throwable> mCallback;
    private String mDomain;
    private byte[] mBitmap;
    private List<String> mCertificates;
    private int mUploadTimeout = 30000;

    public UploadFileRequest(String domain, String relativePath, QueryParams queryParams, List<String> certificates, ICallback<Object, Throwable> callback, byte[] bitmap, Integer uploadTimeout) {
        this.mRelativePath = relativePath;
        this.mQueryParams = queryParams;
        this.mCallback = callback;
        this.mDomain = domain;
        this.mBitmap = bitmap;
        this.mCertificates = certificates;
        if (uploadTimeout != null) {
            this.mUploadTimeout = uploadTimeout;
        }
    }

    public void execute() {
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("https");
        builder.path(this.mDomain + this.mRelativePath);
        this.mQueryParams.appendQueryParameter(builder);
        HttpPutRequest httpPutRequest = new HttpPutRequest(builder.build().toString(), LPTraceType.PUSHER_CLEAR_BADGE_COUNT_REQ);
        HttpImageRequestBody body = new HttpImageRequestBody(){

            public byte[] get() {
                return UploadFileRequest.this.mBitmap;
            }

            public String getContentType() {
                return "text/plain";
            }
        };
        httpPutRequest.setBody((HttpRequestBody)body);
        httpPutRequest.setCertificatePinningKeys(this.mCertificates);
        httpPutRequest.setTimeout(this.mUploadTimeout);
        LPLog.INSTANCE.d(TAG, "Sending upload file to swift with timeout: " + this.mUploadTimeout);
        httpPutRequest.setCallback((ICallback)new ICallback<String, Exception>(){

            public void onSuccess(String body) {
                UploadFileRequest.this.mCallback.onSuccess((Object)body);
            }

            public void onError(Exception exception) {
                UploadFileRequest.this.mCallback.onError((Throwable)exception);
            }
        });
        HttpHandler.execute((HttpRequest)httpPutRequest);
    }
}

