/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.offline;

import android.content.ContentValues;
import android.database.Cursor;
import androidx.annotation.WorkerThread;
import com.liveperson.api.response.model.MultiDialog;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.api.response.types.DialogType;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.database.BaseDBRepository;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.cache.DialogsCacheProvider;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.offline.api.OfflineDialogRepository;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0003J(\u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0007H\u0003J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0003J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\rH\u0016R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/liveperson/messaging/offline/OfflineDialogRepositoryImpl;", "Lcom/liveperson/infra/database/BaseDBRepository;", "Lcom/liveperson/messaging/offline/api/OfflineDialogRepository;", "dialogsCacheProvider", "Lcom/liveperson/messaging/cache/DialogsCacheProvider;", "(Lcom/liveperson/messaging/cache/DialogsCacheProvider;)V", "cachedActiveDialog", "Lcom/liveperson/messaging/model/Dialog;", "getCachedActiveDialog", "()Lcom/liveperson/messaging/model/Dialog;", "clearOfflineDialog", "", "targetId", "", "createAndSaveOfflineDialog", "brandId", "conversationId", "requestId", "", "getOrCreateOfflineDialog", "insertOfflineDialog", "dialog", "queryOfflineDialog", "queryRealActiveDialog", "Companion", "messaging_release"})
public final class OfflineDialogRepositoryImpl
extends BaseDBRepository
implements OfflineDialogRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DialogsCacheProvider dialogsCacheProvider;
    @NotNull
    private static final String TAG = "OfflineDialogRepositoryImpl";

    public OfflineDialogRepositoryImpl(@NotNull DialogsCacheProvider dialogsCacheProvider) {
        Intrinsics.checkNotNullParameter((Object)dialogsCacheProvider, (String)"dialogsCacheProvider");
        super("dialogs");
        this.dialogsCacheProvider = dialogsCacheProvider;
    }

    @Override
    @Nullable
    public Dialog getCachedActiveDialog() {
        return this.dialogsCacheProvider.getActiveDialog();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public Dialog getOrCreateOfflineDialog(@NotNull String targetId, @NotNull String brandId, @NotNull String conversationId, long requestId) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter((Object)conversationId, (String)"conversationId");
        var7_5 = this.dialogsCacheProvider.getDialogById("OFFLINE_DIALOG");
        if (var7_5 == null) ** GOTO lbl-1000
        it = var9_6 = var7_5;
        $i$a$-takeIf-OfflineDialogRepositoryImpl$getOrCreateOfflineDialog$offlineDialog$1 = false;
        v0 = var8_10 = Intrinsics.areEqual((Object)it.getTargetId(), (Object)targetId) != false ? var9_6 : null;
        if (var8_10 == null) ** GOTO lbl-1000
        it = var10_7 = var8_10;
        $i$a$-takeIf-OfflineDialogRepositoryImpl$getOrCreateOfflineDialog$offlineDialog$2 = false;
        v1 = var9_6 = Intrinsics.areEqual((Object)it.getBrandId(), (Object)brandId) != false ? var10_7 : null;
        if (var9_6 != null) {
            v2 = var9_6;
        } else if ((v2 = this.queryOfflineDialog(targetId, brandId, conversationId)) == null) {
            v2 = this.createAndSaveOfflineDialog(targetId, brandId, conversationId, requestId);
        }
        offlineDialog = v2;
        this.dialogsCacheProvider.cacheDialog(offlineDialog);
        return offlineDialog;
    }

    @Override
    public void clearOfflineDialog(@NotNull String targetId) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        String whereClause = "target_id = ? AND dialog_id = ?";
        String[] stringArray = new String[]{targetId, "OFFLINE_DIALOG"};
        String[] whereArgs = stringArray;
        this.getDB().removeAll(whereClause, whereArgs);
        this.dialogsCacheProvider.removeDialogFromCache(targetId, "OFFLINE_DIALOG");
        LPLog.INSTANCE.d(TAG, "Finished removing offline dialog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Dialog queryRealActiveDialog(@NotNull String brandId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        String query = "brand_id = ? AND state = ? AND dialog_id != ? AND dialog_id != ?";
        String[] stringArray = new String[]{brandId, String.valueOf(DialogState.OPEN.ordinal()), "TEMP_DIALOG", "OFFLINE_DIALOG"};
        String[] arguments = stringArray;
        OfflineDialogRepositoryImpl offlineDialogRepositoryImpl = this;
        try {
            Dialog dialog;
            OfflineDialogRepositoryImpl $this$queryRealActiveDialog_u24lambda_u2d5 = offlineDialogRepositoryImpl;
            boolean bl = false;
            Cursor cursor = $this$queryRealActiveDialog_u24lambda_u2d5.getDB().query(null, query, arguments, null, null, null, "1");
            if (cursor != null) {
                Closeable closeable = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Dialog dialog2;
                    Cursor cursor2;
                    Cursor it = (Cursor)closeable;
                    boolean bl2 = false;
                    Cursor it2 = cursor2 = it;
                    boolean bl3 = false;
                    Object object2 = it2.moveToFirst() ? cursor2 : null;
                    if (object2 != null) {
                        it2 = object2;
                        boolean bl4 = false;
                        dialog2 = new Dialog(it2);
                    } else {
                        dialog2 = null;
                    }
                    Dialog dialog3 = dialog2;
                    dialog = dialog3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                dialog = null;
            }
            object = Result.constructor-impl(dialog);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object result = object;
        return (Dialog)(Result.isFailure-impl((Object)result) ? null : result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private final Dialog queryOfflineDialog(String targetId, String brandId, String conversationId) {
        Object object;
        String query = "conversation_id = ? AND target_id = ? AND brand_id = ? AND state = ?";
        String[] stringArray = new String[]{conversationId, targetId, brandId, String.valueOf(DialogState.OFFLINE.ordinal())};
        String[] arguments = stringArray;
        Object object2 = this;
        try {
            Dialog dialog;
            OfflineDialogRepositoryImpl $this$queryOfflineDialog_u24lambda_u2d9 = object2;
            boolean bl = false;
            Cursor cursor = $this$queryOfflineDialog_u24lambda_u2d9.getDB().query(null, query, arguments, null, null, null, "1");
            if (cursor != null) {
                Closeable closeable = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Dialog dialog2;
                    Cursor cursor2;
                    Cursor it = (Cursor)closeable;
                    boolean bl2 = false;
                    Cursor it2 = cursor2 = it;
                    boolean bl3 = false;
                    Object object3 = it2.moveToFirst() ? cursor2 : null;
                    if (object3 != null) {
                        it2 = object3;
                        boolean bl4 = false;
                        dialog2 = new Dialog(it2);
                    } else {
                        dialog2 = null;
                    }
                    Dialog dialog3 = dialog2;
                    dialog = dialog3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                dialog = null;
            }
            object = Result.constructor-impl(dialog);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            LPLog.INSTANCE.d(TAG, "Failed to query for offline dialog", (Throwable)it);
        }
        Object result = object2;
        return (Dialog)(Result.isFailure-impl((Object)result) ? null : result);
    }

    @WorkerThread
    private final Dialog createAndSaveOfflineDialog(String targetId, String brandId, String conversationId, long requestId) {
        Dialog dialog = new Dialog(targetId, brandId);
        dialog.setConversationId(conversationId);
        dialog.setDialogId("OFFLINE_DIALOG");
        dialog.setChannelType(MultiDialog.ChannelType.MESSAGING);
        dialog.setDialogType(DialogType.MAIN);
        dialog.setState(DialogState.OFFLINE);
        dialog.setConversationTTRType(TTRType.NORMAL);
        dialog.setUnreadMessages(-1);
        dialog.setRequestId(requestId);
        dialog.setStartTimestamp(System.currentTimeMillis());
        this.insertOfflineDialog(dialog);
        LPLog.INSTANCE.d(TAG, "Created offline dialog with id: " + dialog.getDialogId());
        return dialog;
    }

    @WorkerThread
    private final void insertOfflineDialog(Dialog dialog) {
        ContentValues insertValues = new ContentValues();
        insertValues.put("dialog_id", dialog.getDialogId());
        insertValues.put("brand_id", dialog.getBrandId());
        insertValues.put("target_id", dialog.getTargetId());
        insertValues.put("conversation_id", dialog.getConversationId());
        insertValues.put("state", Integer.valueOf(dialog.getState().ordinal()));
        insertValues.put("ttr_type", Integer.valueOf(dialog.getConversationTTRType().ordinal()));
        insertValues.put("dialog_type", dialog.getDialogType().name());
        insertValues.put("channel_type", dialog.getChannelType().name());
        insertValues.put("unread_msg_count", Integer.valueOf(-1));
        insertValues.put("start_timestamp", Long.valueOf(dialog.getStartTimestamp()));
        insertValues.put("request_id", Long.valueOf(dialog.getRequestId()));
        this.getDB().insert(insertValues);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/messaging/offline/OfflineDialogRepositoryImpl$Companion;", "", "()V", "TAG", "", "messaging_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

