package com.liveperson.messaging.commands;

import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.MessagingChatMessage;

/**
 * Created by nirni on 12/28/15.
 * <p/>
 * This command derives from SendMessageRequest and implement the sendMessage() method.
 * It differs from the SendMessageRequest by that it will not set the message to the amsMessage but
 * update the existing message state to PENDING
 */
public class ResendMessageCommand extends SendMessageCommand {

    public ResendMessageCommand(Messaging controller, String eventId, String targetId, String brandId, MaskedMessage message) {
        super(controller, targetId, brandId, message);
        mEventId = eventId;
    }

    public ResendMessageCommand(Messaging controller, String eventId, String targetId, String brandId, MaskedMessage message, DeliveryStatusUpdateInfo info) {
        this(controller, eventId, targetId, brandId, message);
        this.mInfo = info;
    }

    @Override
    protected void addMessageToDBAndSend(String dialogId, MaskedMessage message, MessagingChatMessage.MessageState messageState) {
        sendMessageIfDialogIsOpen();
    }

    @Override
    public void execute() {
        super.execute();
    }

    @Override
    protected boolean canSendWhileOffline() {
        return false;
    }
}
