package com.liveperson.messaging.wm.core

import android.content.ContentValues

/**
 * Helper class used to change/remove values in
 * multi-process shared preferences. This interface
 * encapsulates interaction with ContentResolver API for such methods:
 *
 * - @see ContentResolver.insert
 * - @see ContentResolver.update
 * - @see ContentResolver.delete
 */
interface MultiProcessEditorHelper {

    /**
     * Method used to commit changes passed from editor in a synchronous way.
     * @see ContentResolver.insert
     *
     * @param contentValues set of values required to write int shared preferences.
     */
    fun commit(contentValues: ContentValues): Boolean

    /**
     * Method used to commit changes passed from editor in a asynchronous way.
     * @see ContentResolver.insert
     *
     * @param contentValues set of values required to write int shared preferences.
     */
    fun apply(contentValues: ContentValues)

    /**
     * Method used to remove a value from preferences by key.
     * @see ContentResolver.delete
     *
     * @param key an identifier of value required to remove from shared preferences.
     */
    fun remove(key: String)

    /**
     * Method used to clear multi-process shared preferences.
     * @see ContentResolver.delete
     */
    fun clear()
}