/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.background.filesharing;

import java.util.Arrays;
import java.util.List;

public class FileExtensionTypes {
    private static String[] mImageExtensions = new String[]{"jpg", "jpeg", "png", "gif"};
    private static String[] mVoiceExtensions = new String[]{"m4a", "acc", "mp3"};
    private static String[] mDocumentExtensions = new String[]{"docx", "pdf", "xlsx", "pptx"};

    public static List<String> getImageExtensions() {
        return Arrays.asList(mImageExtensions);
    }

    public static List<String> getDocumentExtensions() {
        return Arrays.asList(mDocumentExtensions);
    }

    public static List<String> getVoiceExtensions() {
        return Arrays.asList(mVoiceExtensions);
    }

    public static String getImageExtensionsAsSqlString() {
        return FileExtensionTypes.convertArrayToSqlString(mImageExtensions);
    }

    public static String getVoiceExtensionsAsSqlString() {
        return FileExtensionTypes.convertArrayToSqlString(mVoiceExtensions);
    }

    public static String getDocumentExtensionsAsSqlString() {
        return FileExtensionTypes.convertArrayToSqlString(mDocumentExtensions);
    }

    private static String convertArrayToSqlString(String[] array) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            String imageExtension = array[i];
            sb.append("'").append(imageExtension).append("'");
            if (i >= array.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

