/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.commands.BasicQueryMessagesCommand;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionCallback;
import com.liveperson.messaging.commands.tasks.MessagingEventSubscriptionManager;

public class QueryMessagesUMSCommand
extends BasicQueryMessagesCommand {
    private static final String TAG = "QueryMessagesUMSCommand";
    private int lastCurrentSequence;
    private LocalBroadcastReceiver mLocalBroadcastReceiver;

    public QueryMessagesUMSCommand(Messaging controller, String brandId, String conversationId, String dialogId, int lastCurrentSequence, boolean updateUI) {
        super(controller, brandId, conversationId, dialogId, updateUI);
        this.lastCurrentSequence = lastCurrentSequence;
    }

    public void execute() {
        LPLog.INSTANCE.d(TAG, "Sending query messages from sequence " + this.lastCurrentSequence);
        this.controller.getMessagingEventSubscriptionManager().addSubscription(this.controller, this.brandID, this.conversationId, this.dialogId, this.lastCurrentSequence, this.mUpdateUI);
    }

    @Override
    public void setResponseCallBack(BaseAmsSocketConnectionCallback callBack) {
        super.setResponseCallBack(callBack);
        if (this.mLocalBroadcastReceiver == null) {
            this.mLocalBroadcastReceiver = new LocalBroadcastReceiver.Builder().addAction(MessagingEventSubscriptionManager.Companion.getMESSAGE_EVENT_COMPLETED() + this.dialogId).build((context, intent) -> {
                this.mLocalBroadcastReceiver.unregister();
                LPLog.INSTANCE.d(TAG, "Got Message Event notification for dialog id: " + this.dialogId + " conversation ID: " + this.conversationId + ". Sending callback finished successfully");
                if (intent.getBooleanExtra(MessagingEventSubscriptionManager.Companion.getSUCCESS(), false)) {
                    DataBaseExecutor.execute(() -> this.mResponseCallBack.onTaskSuccess());
                } else {
                    DataBaseExecutor.execute(() -> {
                        String key = MessagingEventSubscriptionManager.getERROR_MESSAGE();
                        String value = intent.getStringExtra(key);
                        Exception exception = new Exception(value);
                        this.mResponseCallBack.onTaskError(SocketTaskType.QUERY_MESSAGES, exception);
                    });
                }
            });
        }
        this.mLocalBroadcastReceiver.register();
    }
}

