/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.pusher;

import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ForegroundService;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.body.HttpRequestBody;
import com.liveperson.infra.network.http.body.LPJSONObjectBody;
import com.liveperson.infra.network.http.request.HttpPutRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.infra.otel.LPTraceType;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.model.AmsUsers;
import com.liveperson.messaging.model.SynchronizedInternetConnectionCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001e\u0010\u0006\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b\u0012\b\u0012\u00060\tj\u0002`\n\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u001c\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u001aj\b\u0012\u0004\u0012\u00020\u0005`\u001b*\u00020\u001cH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR)\u0010\u0006\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b\u0012\b\u0012\u00060\tj\u0002`\n\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/liveperson/messaging/commands/pusher/ClearUnreadMessagesCountCommand;", "Lcom/liveperson/infra/Command;", "messagingController", "Lcom/liveperson/messaging/Messaging;", "brandId", "", "callback", "Lcom/liveperson/infra/ICallback;", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Lcom/liveperson/messaging/Messaging;Ljava/lang/String;Lcom/liveperson/infra/ICallback;)V", "getBrandId", "()Ljava/lang/String;", "getCallback", "()Lcom/liveperson/infra/ICallback;", "getMessagingController", "()Lcom/liveperson/messaging/Messaging;", "execute", "", "getBody", "Lorg/json/JSONObject;", "sendRequest", "requestURL", "validateStateAndSendRequest", "toArrayList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "Lorg/json/JSONArray;", "Companion", "messaging_release"})
public final class ClearUnreadMessagesCountCommand
implements Command {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Messaging messagingController;
    @NotNull
    private final String brandId;
    @Nullable
    private final ICallback<List<String>, Exception> callback;
    @NotNull
    private static final String TAG = "ClearUnreadMessagesCountCommand";
    @NotNull
    private static final String PUSHER_URL = "https://%s/api/account/%s/device/clear-badge-count";
    @NotNull
    private static final String CONSUMER_ID = "consumerId";
    private static boolean hasClearedBadge;

    public ClearUnreadMessagesCountCommand(@NotNull Messaging messagingController, @NotNull String brandId, @Nullable ICallback<List<String>, Exception> callback) {
        Intrinsics.checkNotNullParameter((Object)messagingController, (String)"messagingController");
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        this.messagingController = messagingController;
        this.brandId = brandId;
        this.callback = callback;
    }

    @NotNull
    public final Messaging getMessagingController() {
        return this.messagingController;
    }

    @NotNull
    public final String getBrandId() {
        return this.brandId;
    }

    @Nullable
    public final ICallback<List<String>, Exception> getCallback() {
        return this.callback;
    }

    public void execute() {
        if (hasClearedBadge || !ForegroundService.getInstance().isBrandForeground(this.brandId)) {
            LPLog.INSTANCE.i(TAG, "Unread count is already cleared. Ignore request.");
            return;
        }
        hasClearedBadge = true;
        String string2 = this.messagingController.mAccountsController.getServiceUrl(this.brandId, "pusher");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"messagingController.mAcc\u2026SHER_DOMAIN_KEY\n        )");
        String pusherDomain = string2;
        String string3 = PUSHER_URL;
        Object[] objectArray = new Object[]{pusherDomain, this.brandId};
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        String requestURL = string4;
        this.validateStateAndSendRequest(requestURL);
    }

    private final void validateStateAndSendRequest(String requestURL) {
        if (InternetConnectionService.isNetworkAvailable()) {
            this.sendRequest(requestURL);
        } else {
            new SynchronizedInternetConnectionCallback(() -> ClearUnreadMessagesCountCommand.validateStateAndSendRequest$lambda-0(this, requestURL)).execute();
        }
    }

    private final void sendRequest(String requestURL) {
        AccountsController accountsController = this.messagingController.mAccountsController;
        String token = accountsController != null ? accountsController.getToken(this.brandId) : null;
        CharSequence charSequence = token;
        if (charSequence == null || charSequence.length() == 0) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000169, "Authorization failed. Token is missing");
            ICallback<List<String>, Exception> iCallback = this.callback;
            if (iCallback != null) {
                iCallback.onError((Throwable)new Exception("Authorization failed. Token is missing"));
            }
            return;
        }
        JSONObject requestJson = this.getBody();
        HttpPutRequest httpPutRequest = new HttpPutRequest(requestURL, LPTraceType.PUSHER_CLEAR_BADGE_COUNT_REQ);
        HttpRequestBody jsonBody = (HttpRequestBody)new LPJSONObjectBody(requestJson);
        httpPutRequest.setBody(jsonBody);
        httpPutRequest.addHeader("authorization", "bearer " + token);
        httpPutRequest.setCallback((ICallback)new ICallback<String, Exception>(this){
            final /* synthetic */ ClearUnreadMessagesCountCommand this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@Nullable String value) {
                block3: {
                    try {
                        if (!TextUtils.isEmpty((CharSequence)value)) {
                            LPLog.INSTANCE.d("ClearUnreadMessagesCountCommand", "onSuccess: " + value);
                            JSONArray result = new JSONArray(value);
                            ICallback<List<String>, Exception> iCallback = this.this$0.getCallback();
                            if (iCallback == null) break block3;
                            iCallback.onSuccess((Object)ClearUnreadMessagesCountCommand.access$toArrayList(this.this$0, result));
                            break block3;
                        }
                        LPLog.INSTANCE.i("ClearUnreadMessagesCountCommand", "Received empty response from pusher for clear-badge-count request");
                    }
                    catch (Exception error) {
                        ClearUnreadMessagesCountCommand.access$setHasClearedBadge$cp(false);
                        LPLog.INSTANCE.e("ClearUnreadMessagesCountCommand", ErrorCode.ERR_00000167, "Failed to parse clear-badge-count response: ", (Throwable)error);
                        ICallback<List<String>, Exception> iCallback = this.this$0.getCallback();
                        if (iCallback == null) break block3;
                        iCallback.onError((Throwable)error);
                    }
                }
            }

            public void onError(@Nullable Exception exception) {
                block1: {
                    ClearUnreadMessagesCountCommand.access$setHasClearedBadge$cp(false);
                    if (exception == null) break block1;
                    LPLog.INSTANCE.e("ClearUnreadMessagesCountCommand", ErrorCode.ERR_00000168, "Failed to clear badge count for the consumer");
                    ICallback<List<String>, Exception> iCallback = this.this$0.getCallback();
                    if (iCallback != null) {
                        iCallback.onError((Throwable)exception);
                    }
                }
            }
        });
        LPLog.INSTANCE.i(TAG, "Sending clear-badge-count to pusher");
        HttpHandler.execute((HttpRequest)((HttpRequest)httpPutRequest));
    }

    private final JSONObject getBody() {
        JSONObject requestBody = new JSONObject();
        try {
            AmsUsers amsUsers = this.messagingController.amsUsers;
            requestBody.put(CONSUMER_ID, (Object)(amsUsers != null ? amsUsers.getConsumerId(this.brandId) : null));
        }
        catch (Exception error) {
            hasClearedBadge = false;
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000016A, "getBody: ", (Throwable)error);
        }
        return requestBody;
    }

    private final ArrayList<String> toArrayList(JSONArray $this$toArrayList) {
        ArrayList<String> list = new ArrayList<String>();
        int n = $this$toArrayList.length();
        for (int i = 0; i < n; ++i) {
            list.add($this$toArrayList.getString(i));
        }
        return list;
    }

    private static final void validateStateAndSendRequest$lambda-0(ClearUnreadMessagesCountCommand this$0, String $requestURL) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$requestURL, (String)"$requestURL");
        this$0.sendRequest($requestURL);
    }

    public static final /* synthetic */ ArrayList access$toArrayList(ClearUnreadMessagesCountCommand $this, JSONArray $receiver) {
        return $this.toArrayList($receiver);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/liveperson/messaging/commands/pusher/ClearUnreadMessagesCountCommand$Companion;", "", "()V", "CONSUMER_ID", "", "PUSHER_URL", "TAG", "hasClearedBadge", "", "clearRequestState", "", "messaging_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void clearRequestState() {
            LPLog.INSTANCE.i(ClearUnreadMessagesCountCommand.TAG, "cleanRequestState");
            hasClearedBadge = false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

