/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import android.content.Context;
import android.text.TextUtils;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.Consumer;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.model.AmsConnectionAnalytics;
import com.liveperson.messaging.network.http.GetActiveConversationsRequest;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 -2\u00020\u0001:\u0001-B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0007H\u0016J\u0010\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020\u0007H\u0002J\u001e\u0010)\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\f\u0012\n\u0018\u00010+j\u0004\u0018\u0001`,0*H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000e\"\u0004\b\u001b\u0010\u0010R\"\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u000e\"\u0004\b#\u0010\u0010\u00a8\u0006."}, d2={"Lcom/liveperson/messaging/commands/tasks/GetActiveConversationsUmsTask;", "Lcom/liveperson/messaging/commands/tasks/BaseAmsAccountConnectionTask;", "context", "Landroid/content/Context;", "accountsController", "Lcom/liveperson/messaging/controller/AccountsController;", "umsDomain", "", "brandId", "(Landroid/content/Context;Lcom/liveperson/messaging/controller/AccountsController;Ljava/lang/String;Ljava/lang/String;)V", "getAccountsController", "()Lcom/liveperson/messaging/controller/AccountsController;", "consumerId", "getConsumerId", "()Ljava/lang/String;", "setConsumerId", "(Ljava/lang/String;)V", "getContext", "()Landroid/content/Context;", "getActiveConversationsRequest", "Lcom/liveperson/messaging/network/http/GetActiveConversationsRequest;", "getGetActiveConversationsRequest", "()Lcom/liveperson/messaging/network/http/GetActiveConversationsRequest;", "setGetActiveConversationsRequest", "(Lcom/liveperson/messaging/network/http/GetActiveConversationsRequest;)V", "lpToken", "getLpToken", "setLpToken", "result", "", "getResult", "()Ljava/util/List;", "setResult", "(Ljava/util/List;)V", "getUmsDomain", "setUmsDomain", "execute", "", "getName", "notifyError", "message", "prepareCallback", "Lcom/liveperson/infra/ICallback;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Companion", "messaging_release"})
public class GetActiveConversationsUmsTask
extends BaseAmsAccountConnectionTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final AccountsController accountsController;
    @Nullable
    private String umsDomain;
    @Nullable
    private List<String> result;
    @Nullable
    private GetActiveConversationsRequest getActiveConversationsRequest;
    @Nullable
    private String consumerId;
    @Nullable
    private String lpToken;
    @NotNull
    private static final String TAG = "GetActiveConversationTask";

    public GetActiveConversationsUmsTask(@NotNull Context context, @NotNull AccountsController accountsController, @Nullable String umsDomain, @NotNull String brandId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accountsController, (String)"accountsController");
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        this.context = context;
        this.accountsController = accountsController;
        this.umsDomain = umsDomain;
        this.mBrandId = brandId;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final AccountsController getAccountsController() {
        return this.accountsController;
    }

    @Nullable
    public final String getUmsDomain() {
        return this.umsDomain;
    }

    public final void setUmsDomain(@Nullable String string2) {
        this.umsDomain = string2;
    }

    @Nullable
    public final List<String> getResult() {
        return this.result;
    }

    public final void setResult(@Nullable List<String> list) {
        this.result = list;
    }

    @Nullable
    public final GetActiveConversationsRequest getGetActiveConversationsRequest() {
        return this.getActiveConversationsRequest;
    }

    public final void setGetActiveConversationsRequest(@Nullable GetActiveConversationsRequest getActiveConversationsRequest) {
        this.getActiveConversationsRequest = getActiveConversationsRequest;
    }

    @Nullable
    public final String getConsumerId() {
        return this.consumerId;
    }

    public final void setConsumerId(@Nullable String string2) {
        this.consumerId = string2;
    }

    @Nullable
    public final String getLpToken() {
        return this.lpToken;
    }

    public final void setLpToken(@Nullable String string2) {
        this.lpToken = string2;
    }

    public void execute() {
        block8: {
            if (this.consumerId == null) {
                Consumer consumer = Infra.instance.getConsumerManager().getActiveConsumer();
                String string2 = this.consumerId = consumer != null ? consumer.getConsumerId() : null;
            }
            if (this.lpToken == null) {
                Consumer consumer = Infra.instance.getConsumerManager().getActiveConsumer();
                String string3 = this.lpToken = consumer != null ? consumer.getLpToken() : null;
            }
            if (this.umsDomain == null) {
                this.umsDomain = MessagingFactory.getInstance().getController().mAccountsController.getServiceUrl(this.mBrandId, "asyncMessagingEnt");
            }
            String string4 = this.umsDomain;
            if (string4 == null) {
                this.notifyError("Failed to receive umsDomain");
                return;
            }
            String domain = string4;
            String string5 = this.mBrandId;
            if (string5 == null) {
                this.notifyError("Failed to receive mBrandId");
                return;
            }
            String brand = string5;
            String string6 = this.consumerId;
            if (string6 == null) {
                this.notifyError("Failed to receive ums consumerId");
                return;
            }
            String consumer = string6;
            String string7 = this.lpToken;
            if (string7 == null) {
                this.notifyError("Failed to receive ums lpToken");
                return;
            }
            String token = string7;
            LPLog.INSTANCE.d(TAG, "Running GetActiveConversations Task...");
            AmsConnectionAnalytics.getActiveConversationTaskStart();
            if (this.getActiveConversationsRequest == null) {
                List<String> list = this.accountsController.getCertificatePinningKeys(this.mBrandId);
                GetActiveConversationsRequest.GetActiveConversationsRequestData data = new GetActiveConversationsRequest.GetActiveConversationsRequestData(domain, brand, token, consumer, null, null, null, null, null, null, list, 1008, null);
                this.getActiveConversationsRequest = new GetActiveConversationsRequest(data, this.prepareCallback());
            }
            GetActiveConversationsRequest getActiveConversationsRequest = this.getActiveConversationsRequest;
            if (getActiveConversationsRequest == null) break block8;
            getActiveConversationsRequest.execute();
        }
    }

    private final void notifyError(String message) {
        LPLog.INSTANCE.w(TAG, message);
        this.getCallback().onTaskError(TaskType.GET_ACTIVE_CONVERSATIONS, LpError.GET_ACTIVE_CONVERSATIONS_FAILURE, new Exception(message));
    }

    private final ICallback<String, Exception> prepareCallback() {
        return (ICallback)new ICallback<String, Exception>(this){
            final /* synthetic */ GetActiveConversationsUmsTask this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@Nullable String value) {
                if (!TextUtils.isEmpty((CharSequence)value)) {
                    this.this$0.setResult((List<String>)new ArrayList<E>());
                    try {
                        String string2 = value;
                        Intrinsics.checkNotNull((Object)string2);
                        JSONObject jsonObject = new JSONObject(string2);
                        JSONArray array = jsonObject.getJSONArray("data");
                        if (array.length() > 0) {
                            int n = array.length();
                            for (int i = 0; i < n; ++i) {
                                Object object = array.optJSONObject(i);
                                if (object == null || (object = object.getString("id")) == null) continue;
                                Object object2 = object;
                                GetActiveConversationsUmsTask getActiveConversationsUmsTask = this.this$0;
                                Object it = object2;
                                boolean bl = false;
                                List<String> list = getActiveConversationsUmsTask.getResult();
                                if (list == null) continue;
                                list.add((String)it);
                            }
                        }
                        this.this$0.getCallback().onTaskSuccess();
                    }
                    catch (Exception ex) {
                        this.onError(ex);
                    }
                } else {
                    this.onError(new Exception("GetActiveConversations task failure. Value: " + value));
                }
                AmsConnectionAnalytics.getActiveConversationTaskEnd();
            }

            public void onError(@Nullable Exception exception) {
                this.this$0.getCallback().onTaskError(TaskType.GET_ACTIVE_CONVERSATIONS, LpError.GET_ACTIVE_CONVERSATIONS_FAILURE, exception);
                AmsConnectionAnalytics.getActiveConversationTaskEnd();
            }
        };
    }

    @Override
    @NotNull
    public String getName() {
        return TAG;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/messaging/commands/tasks/GetActiveConversationsUmsTask$Companion;", "", "()V", "TAG", "", "messaging_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

