/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.controller.connection;

import com.liveperson.infra.Infra;
import com.liveperson.infra.statemachine.interfaces.IState;
import com.liveperson.infra.statemachine.interfaces.IStateMachine;
import com.liveperson.messaging.commands.tasks.ACCDNConnectorsTask;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.commands.tasks.CloseConnectionTask;
import com.liveperson.messaging.commands.tasks.CollectSDKConfigurationDataTask;
import com.liveperson.messaging.commands.tasks.ConcurrentTasks;
import com.liveperson.messaging.commands.tasks.ConfigurationFetcherTask;
import com.liveperson.messaging.commands.tasks.CsdsTask;
import com.liveperson.messaging.commands.tasks.DataBaseTask;
import com.liveperson.messaging.commands.tasks.IdpTask;
import com.liveperson.messaging.commands.tasks.LptagTask;
import com.liveperson.messaging.commands.tasks.OpenSocketTask;
import com.liveperson.messaging.commands.tasks.RemoveOlderImagesTask;
import com.liveperson.messaging.commands.tasks.SiteSettingsFetcherTask;
import com.liveperson.messaging.commands.tasks.UnAuthGetEngagementTask;
import com.liveperson.messaging.controller.connection.DefaultTaskCallbackAmsAccount;
import com.liveperson.messaging.controller.connection.MessagingStateMachineInterface;
import java.util.ArrayList;
import java.util.List;

public class ConnectionTasksHolder {
    private final BaseAmsAccountConnectionTask mCsdsTask;
    private final BaseAmsAccountConnectionTask mLptagTask;
    private final BaseAmsAccountConnectionTask mConfigurationFetcherTask;
    private final BaseAmsAccountConnectionTask mSiteSettingsFetcherTask;
    private final BaseAmsAccountConnectionTask acCdnConnectorsTask;
    private final BaseAmsAccountConnectionTask mIdpTask;
    private final BaseAmsAccountConnectionTask mUnAuthGetEngagementTask;
    private final BaseAmsAccountConnectionTask mRemoveOlderImagesTask;
    private final BaseAmsAccountConnectionTask mDataBaseTask;
    private final BaseAmsAccountConnectionTask mOpenSocketTask;
    private final BaseAmsAccountConnectionTask mCollectSDKConfigurationDataTask;
    private final BaseAmsAccountConnectionTask mCloseConnectionTask;
    private final BaseAmsAccountConnectionTask mConcurrentTasks;
    private final MessagingStateMachineInterface mController;
    private List<BaseAmsAccountConnectionTask> mPrimaryFullConnectingTasks;
    private List<BaseAmsAccountConnectionTask> mPrimaryShortConnectingTasks;
    private List<BaseAmsAccountConnectionTask> mPrimaryShortConnectingForApiUsageTasks;
    private List<BaseAmsAccountConnectionTask> mSecondaryConnectingTasks;
    private List<BaseAmsAccountConnectionTask> mDisconnectingTasks;

    public ConnectionTasksHolder(IStateMachine<IState> stateMachine, MessagingStateMachineInterface messagingController, String brandId) {
        this.mController = messagingController;
        String hostVersion = Infra.instance.getHostVersion();
        this.mCsdsTask = new CsdsTask(Infra.instance.getApplicationContext(), this.mController.getAccountsController(), brandId);
        this.mCsdsTask.setCallback(new DefaultTaskCallbackAmsAccount(stateMachine, this.mCsdsTask.getClass().getSimpleName()));
        this.mLptagTask = new LptagTask(this.mController.getAccountsController());
        this.mConfigurationFetcherTask = new ConfigurationFetcherTask(this.mController.getAccountsController());
        this.mSiteSettingsFetcherTask = new SiteSettingsFetcherTask(this.mController.getAccountsController());
        this.acCdnConnectorsTask = new ACCDNConnectorsTask(this.mController.getAccountsController());
        this.acCdnConnectorsTask.setCallback(new DefaultTaskCallbackAmsAccount(stateMachine, this.acCdnConnectorsTask.getClass().getSimpleName()));
        this.mIdpTask = new IdpTask(this.mController.getAccountsController(), this.mController.getAmsUsers(), hostVersion);
        this.mUnAuthGetEngagementTask = new UnAuthGetEngagementTask(this.mController.getAccountsController());
        this.mUnAuthGetEngagementTask.setCallback(new DefaultTaskCallbackAmsAccount(stateMachine, this.mUnAuthGetEngagementTask.getClass().getSimpleName()));
        this.mRemoveOlderImagesTask = new RemoveOlderImagesTask(brandId);
        this.mCollectSDKConfigurationDataTask = new CollectSDKConfigurationDataTask();
        this.mCollectSDKConfigurationDataTask.setCallback(new DefaultTaskCallbackAmsAccount(stateMachine, this.mCollectSDKConfigurationDataTask.getClass().getSimpleName()));
        this.mDataBaseTask = new DataBaseTask(this.mController.getAmsUsers(), this.mController.getAmsConversations(), this.mController.getAmsDialogs());
        this.mOpenSocketTask = new OpenSocketTask(this.mController.getAccountsController(), this.mController.getConnectionController());
        this.mOpenSocketTask.setCallback(new DefaultTaskCallbackAmsAccount(stateMachine, this.mOpenSocketTask.getClass().getSimpleName()));
        this.mCloseConnectionTask = new CloseConnectionTask(this.mController.getAccountsController());
        this.mCloseConnectionTask.setCallback(new DefaultTaskCallbackAmsAccount(stateMachine, this.mCloseConnectionTask.getClass().getSimpleName()));
        this.mConcurrentTasks = new ConcurrentTasks();
        this.mConcurrentTasks.setCallback(new DefaultTaskCallbackAmsAccount(stateMachine, this.mConcurrentTasks.getClass().getSimpleName()));
        this.mPrimaryFullConnectingTasks = this.constructPrimaryFullConnectionTasks();
        this.mPrimaryShortConnectingTasks = this.constructPrimaryShortConnectionTasks();
        this.mPrimaryShortConnectingForApiUsageTasks = this.constructPrimaryConnectionForApiUsageTasks();
        this.mSecondaryConnectingTasks = this.constructSecondaryConnectionTasks();
        this.mDisconnectingTasks = this.constructDisconnectingTasks();
    }

    public List<BaseAmsAccountConnectionTask> constructPrimaryFullConnectionTasks() {
        ArrayList<BaseAmsAccountConnectionTask> connectingTasks = new ArrayList<BaseAmsAccountConnectionTask>();
        connectingTasks.add(this.mCsdsTask);
        connectingTasks.add(this.mUnAuthGetEngagementTask);
        connectingTasks.add(this.acCdnConnectorsTask);
        connectingTasks.add(this.mConcurrentTasks);
        connectingTasks.add(this.mOpenSocketTask);
        return connectingTasks;
    }

    public List<BaseAmsAccountConnectionTask> constructPrimaryShortConnectionTasks() {
        ArrayList<BaseAmsAccountConnectionTask> connectingTasks = new ArrayList<BaseAmsAccountConnectionTask>();
        connectingTasks.add(this.mUnAuthGetEngagementTask);
        connectingTasks.add(this.mConcurrentTasks);
        connectingTasks.add(this.mOpenSocketTask);
        return connectingTasks;
    }

    public List<BaseAmsAccountConnectionTask> constructPrimaryConnectionForApiUsageTasks() {
        ArrayList<BaseAmsAccountConnectionTask> connectingTasks = new ArrayList<BaseAmsAccountConnectionTask>();
        connectingTasks.add(this.mCsdsTask);
        connectingTasks.add(this.mUnAuthGetEngagementTask);
        connectingTasks.add(this.acCdnConnectorsTask);
        connectingTasks.add(this.mConcurrentTasks);
        connectingTasks.add(this.mOpenSocketTask);
        return connectingTasks;
    }

    public List<BaseAmsAccountConnectionTask> constructSecondaryConnectionTasks() {
        ArrayList<BaseAmsAccountConnectionTask> connectingTasks = new ArrayList<BaseAmsAccountConnectionTask>();
        connectingTasks.add(this.mConcurrentTasks);
        connectingTasks.add(this.mCsdsTask);
        return connectingTasks;
    }

    private List<BaseAmsAccountConnectionTask> constructDisconnectingTasks() {
        ArrayList<BaseAmsAccountConnectionTask> disconnectingTasks = new ArrayList<BaseAmsAccountConnectionTask>();
        disconnectingTasks.add(this.mCloseConnectionTask);
        return disconnectingTasks;
    }

    private void constructConcurrentFullConnectionTasks() {
        this.mConcurrentTasks.resetConcurrentTasks();
        this.mConcurrentTasks.addConcurrentTask(this.mLptagTask);
        this.mConcurrentTasks.addConcurrentTask(this.mConfigurationFetcherTask);
        this.mConcurrentTasks.addConcurrentTask(this.mSiteSettingsFetcherTask);
        this.mConcurrentTasks.addConcurrentTask(this.mDataBaseTask);
        this.mConcurrentTasks.addConcurrentTask(this.mIdpTask);
        this.mConcurrentTasks.addConcurrentTask(this.mRemoveOlderImagesTask);
    }

    private void constructPrimaryShortConnectionConcurrentTasks() {
        this.mConcurrentTasks.resetConcurrentTasks();
        this.mConcurrentTasks.addConcurrentTask(this.mDataBaseTask);
        this.mConcurrentTasks.addConcurrentTask(this.mIdpTask);
    }

    private void constructPrimaryShortConnectionForApiUsageConcurrentTasks() {
        this.mConcurrentTasks.resetConcurrentTasks();
        this.mConcurrentTasks.addConcurrentTask(this.mIdpTask);
    }

    private void constructSecondaryConnectionConcurrentTasks() {
        this.mConcurrentTasks.resetConcurrentTasks();
        this.mConcurrentTasks.addConcurrentTask(this.mConfigurationFetcherTask);
        this.mConcurrentTasks.addConcurrentTask(this.mSiteSettingsFetcherTask);
        this.mConcurrentTasks.addConcurrentTask(this.mRemoveOlderImagesTask);
        this.mConcurrentTasks.addConcurrentTask(this.mLptagTask);
    }

    public List<BaseAmsAccountConnectionTask> getPrimaryFullConnectionTasks() {
        this.constructConcurrentFullConnectionTasks();
        return this.mPrimaryFullConnectingTasks;
    }

    public List<BaseAmsAccountConnectionTask> getPrimaryShortConnectionTasks() {
        this.constructPrimaryShortConnectionConcurrentTasks();
        return this.mPrimaryShortConnectingTasks;
    }

    public List<BaseAmsAccountConnectionTask> getSecondaryConnectionTasks() {
        this.constructSecondaryConnectionConcurrentTasks();
        return this.mSecondaryConnectingTasks;
    }

    public List<BaseAmsAccountConnectionTask> getPrimaryShortConnectingForApiUsageTasks() {
        this.constructPrimaryShortConnectionForApiUsageConcurrentTasks();
        return this.mPrimaryShortConnectingForApiUsageTasks;
    }

    public List<BaseAmsAccountConnectionTask> getDisconnectionTasks() {
        return this.mDisconnectingTasks;
    }
}

