/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.os.Bundle;
import androidx.annotation.NonNull;
import com.liveperson.infra.ForegroundService;
import com.liveperson.infra.ForegroundServiceInterface;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.FlowTags;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.infra.network.socket.SocketState;
import com.liveperson.infra.network.socket.state.SocketStateListener;
import com.liveperson.infra.otel.LPTraceSpan;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDownAsync;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDownCompletionListener;
import com.liveperson.infra.statemachine.StateMachineExecutor;
import com.liveperson.infra.statemachine.interfaces.IStateMachine;
import com.liveperson.infra.statemachine.interfaces.IStateMachineExecutor;
import com.liveperson.infra.utils.LocalBroadcast;
import com.liveperson.messaging.IMessaging;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.InitAmsSessionCommand;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionCallback;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.controller.ConnectionsController;
import com.liveperson.messaging.controller.connection.ConnectionStateMachine;
import com.liveperson.messaging.controller.connection.IConnectionListener;
import com.liveperson.messaging.controller.connection.InternetInformationProvider;
import com.liveperson.messaging.controller.connection.MessagingStateMachineInterface;
import com.liveperson.messaging.model.AmsConnectionAnalytics;
import com.liveperson.messaging.model.AmsConversations;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.AmsMessages;
import com.liveperson.messaging.model.AmsUsers;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.offline.OfflineMessagingManager;

public class AmsConnection
implements ShutDownAsync {
    private static final String TAG = "AmsConnection";
    public static final String BROADCAST_CONNECTING_TO_SERVER_ERROR = "BROADCAST_CONNECTING_TO_SERVER_ERROR";
    public static final String BROADCAST_START_CONNECTING = "BROADCAST_START_CONNECTING";
    public static final String BROADCAST_SOCKET_OPEN_ACTION = "BROADCAST_SOCKET_OPEN_ACTION";
    public static final String BROADCAST_KEY_SOCKET_READY_ACTION = "BROADCAST_KEY_SOCKET_READY_ACTION";
    public static final String BROADCAST_KEY_SOCKET_READY_EXTRA = "BROADCAST_KEY_SOCKET_READY_EXTRA";
    public static final String BROADCAST_KEY_BRAND_ID = "BROADCAST_KEY_BRAND_ID";
    public static final String BROADCAST_AMS_CONNECTION_UPDATE_ACTION = "BROADCAST_AMS_CONNECTION_UPDATE_ACTION";
    public static final String BROADCAST_AMS_CONNECTION_UPDATE_EXTRA = "BROADCAST_AMS_CONNECTION_UPDATE_EXTRA";
    public static final String BROADCAST_AMS_TOKEN_EXPIRED = "BROADCAST_AMS_TOKEN_EXPIRED";
    protected String mBrandId;
    private long mClockDiff;
    private boolean firstNotificationAfterSubscribe = true;
    private PreferenceManager mPreferenceManager;
    private AmsSocketState mSocketState;
    private final Messaging mController;
    private ConnectionStateMachine mStateMachine;
    private boolean mIsUpdated = false;
    private boolean mIsAgentDetailsUpdated = false;
    private boolean socketReady = false;

    public AmsConnection(Messaging messagingController, String brandId) {
        this.mController = messagingController;
        this.mPreferenceManager = PreferenceManager.getInstance();
        this.mBrandId = brandId;
        this.mSocketState = new AmsSocketState();
        this.initConnectionStateMachine();
    }

    private void initConnectionStateMachine() {
        IConnectionListener connectionListener = this.createConnectionListener();
        InternetInformationProvider internetInformationProvider = this.createInternetInformationProvider();
        MessagingStateMachineInterface controller = this.createMessagingStateMachineInterface();
        this.mStateMachine = new ConnectionStateMachine(controller, internetInformationProvider, (ForegroundServiceInterface)ForegroundService.getInstance(), this.mBrandId, connectionListener);
        this.mStateMachine.setStateMachineExecutor((IStateMachineExecutor)new StateMachineExecutor(this.mStateMachine.getTag(), (IStateMachine)this.mStateMachine));
    }

    @NonNull
    private MessagingStateMachineInterface createMessagingStateMachineInterface() {
        return new MessagingStateMachineInterface(){

            @Override
            public AccountsController getAccountsController() {
                return ((AmsConnection)AmsConnection.this).mController.mAccountsController;
            }

            @Override
            public ConnectionsController getConnectionController() {
                return ((AmsConnection)AmsConnection.this).mController.mConnectionController;
            }

            @Override
            public AmsMessages getAmsMessages() {
                return ((AmsConnection)AmsConnection.this).mController.amsMessages;
            }

            @Override
            public AmsConversations getAmsConversations() {
                return ((AmsConnection)AmsConnection.this).mController.amsConversations;
            }

            @Override
            public AmsDialogs getAmsDialogs() {
                return ((AmsConnection)AmsConnection.this).mController.amsDialogs;
            }

            @Override
            public AmsUsers getAmsUsers() {
                return ((AmsConnection)AmsConnection.this).mController.amsUsers;
            }

            @Override
            public IMessaging getMessagingController() {
                return AmsConnection.this.mController;
            }
        };
    }

    @NonNull
    private InternetInformationProvider createInternetInformationProvider() {
        return new InternetInformationProvider(){

            @Override
            public boolean isNetworkAvailable() {
                return InternetConnectionService.isNetworkAvailable();
            }

            @Override
            public void unregisterToNetworkChanges() {
                Infra.instance.unregisterToNetworkChanges();
            }

            @Override
            public void registerToNetworkChanges() {
                Infra.instance.registerToNetworkChanges();
            }
        };
    }

    @NonNull
    private IConnectionListener createConnectionListener() {
        return new IConnectionListener(){

            @Override
            public void notifyError(TaskType type, LpError lpError, String message) {
                ((AmsConnection)AmsConnection.this).mController.mEventsProxy.onError(type, message);
                ((AmsConnection)AmsConnection.this).mController.mEventsProxy.onError(lpError, message);
                LocalBroadcast.sendBroadcast((String)AmsConnection.BROADCAST_CONNECTING_TO_SERVER_ERROR);
            }

            @Override
            public void notifyError(LpError lpError, String message) {
                ((AmsConnection)AmsConnection.this).mController.mEventsProxy.onError(lpError, message);
                LocalBroadcast.sendBroadcast((String)AmsConnection.BROADCAST_CONNECTING_TO_SERVER_ERROR);
            }

            @Override
            public void notifyStartConnecting() {
                LocalBroadcast.sendBroadcast((String)AmsConnection.BROADCAST_START_CONNECTING);
                AmsConnectionAnalytics.startConnecting();
                LPLog.INSTANCE.i(AmsConnection.TAG, FlowTags.LOGIN, "Start connecting for brand: " + AmsConnection.this.mBrandId);
            }

            @Override
            public void notifyStartDisconnecting() {
                AmsConnection.this.onDisconnected();
                AmsConnectionAnalytics.startDisconnecting();
            }

            @Override
            public void notifyDisconnected() {
                AmsConnection.this.onDisconnected();
                ((AmsConnection)AmsConnection.this).mController.amsMessages.mMessageTimeoutQueue.removeAll();
            }

            @Override
            public void notifyConnected() {
                LPLog.INSTANCE.i(AmsConnection.TAG, FlowTags.LOGIN, "On connected for brand: " + AmsConnection.this.mBrandId);
                AmsConnectionAnalytics.connected();
            }

            @Override
            public void notifyTokenExpired() {
                AmsConnection.this.notifyHostAppTokenExpired();
            }

            @Override
            public void notifyUserExpired() {
                AmsConnection.this.notifyHostAppUserExpired();
            }
        };
    }

    public AmsSocketState registerSocket() {
        String connectionUrl = this.mController.mAccountsController.getConnectionUrl(this.mBrandId);
        String connectionUrlForLogs = this.mController.mAccountsController.getConnectionUrlForLogs(this.mBrandId);
        LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "Register socket for brand " + this.mBrandId + ", connectionUrl = " + connectionUrlForLogs);
        SocketManager.getInstance().registerToSocketState(connectionUrl, (SocketStateListener)this.mSocketState);
        return this.mSocketState;
    }

    private void unregisterSocketListener() {
        String connectionUrl = this.mController.mAccountsController.getConnectionUrl(this.mBrandId);
        String connectionUrlForLogs = this.mController.mAccountsController.getConnectionUrlForLogs(this.mBrandId);
        LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "Unregister socket for brand " + this.mBrandId + ", connectionUrl = " + connectionUrlForLogs);
        SocketManager.getInstance().unregisterFromSocketState(connectionUrl, (SocketStateListener)this.mSocketState);
    }

    public void networkLost() {
        LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "networkLost: brand " + this.mBrandId);
        this.mStateMachine.networkLost();
    }

    public void networkAvailable() {
        LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "networkAvailable: brand " + this.mBrandId);
        this.mStateMachine.networkAvailable();
    }

    public void moveToForeground() {
        LPLog.INSTANCE.i(TAG, FlowTags.LOGIN, "moveToForeground for brand " + this.mBrandId);
        this.mStateMachine.moveToForeground();
    }

    public void moveToBackground(long timeoutTimerMs) {
        LPLog.INSTANCE.i(TAG, FlowTags.LOGIN, "moveToBackground for brand " + this.mBrandId);
        this.mStateMachine.moveToBackground(timeoutTimerMs);
    }

    public void serviceStarted() {
        LPLog.INSTANCE.i(TAG, FlowTags.LOGIN, "serviceStarted for brand " + this.mBrandId);
        this.mStateMachine.serviceStarted();
    }

    public void serviceStopped() {
        LPLog.INSTANCE.i(TAG, FlowTags.LOGIN, "serviceStopped for brand " + this.mBrandId);
        this.mStateMachine.serviceStopped();
    }

    public void startConnecting(boolean connectInBackground) {
        LPLog.INSTANCE.i(TAG, FlowTags.LOGIN, "startConnecting for brand, connectInBackground = " + connectInBackground);
        this.mStateMachine.startConnecting(connectInBackground);
    }

    private void startDisconnecting() {
        LPLog.INSTANCE.i(TAG, FlowTags.LOGIN, "startDisconnecting for brand " + this.mBrandId);
        this.mStateMachine.startDisconnecting();
    }

    private void onSocketProblem() {
        LPLog.INSTANCE.i(TAG, FlowTags.LOGIN, "onSocketProblem for brand " + this.mBrandId);
        this.mStateMachine.onSocketProblem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSocketOpen() {
        AmsConnection amsConnection = this;
        synchronized (amsConnection) {
            return this.mStateMachine.isConnected();
        }
    }

    private void setSocketReady(boolean connectedAndUpdating) {
        this.socketReady = connectedAndUpdating;
        this.sendSocketReadyStatus();
    }

    public boolean isSocketReady() {
        return this.socketReady;
    }

    private void sendSocketReadyStatus() {
        Bundle connectionBundle = new Bundle();
        connectionBundle.putBoolean(BROADCAST_KEY_SOCKET_READY_EXTRA, this.isSocketReady());
        connectionBundle.putString(BROADCAST_KEY_BRAND_ID, this.mBrandId);
        LocalBroadcast.sendBroadcast((String)BROADCAST_KEY_SOCKET_READY_ACTION, (Bundle)connectionBundle);
    }

    public boolean isConnecting() {
        return this.mStateMachine.isConnecting();
    }

    public long getClockDiff() {
        return this.mClockDiff;
    }

    public void setClock(long clock) {
        this.mClockDiff = clock;
    }

    public long getLastUpdateTime() {
        return this.mPreferenceManager.getLongValue("KEY_PREF_LAST_UPDATE_TIME", this.mBrandId, 0L);
    }

    private void getUpdates() {
        LPLog.INSTANCE.i(TAG, "Socket open - starting updating data...");
        this.initAmsSession();
    }

    private void initAmsSession() {
        new InitAmsSessionCommand(this.mController, this.mBrandId, new ICallback<Object, Throwable>(){

            public void onSuccess(Object value) {
                LPLog.INSTANCE.i(AmsConnection.TAG, FlowTags.LOGIN, "getUpdates - Socket connection updates Success");
                AmsConnectionAnalytics.socketReady();
                AmsConnection.this.setSocketReady(true);
            }

            public void onError(Throwable exception) {
                LPLog.INSTANCE.i(AmsConnection.TAG, FlowTags.LOGIN, "getUpdates - Error. ", exception);
                AmsConnection.this.onSocketProblem();
            }
        }).execute();
    }

    public void notifySocketTaskFailure(LpError error, Throwable exception) {
        this.mStateMachine.notifyLPError(error, exception);
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.mPreferenceManager.setLongValue("KEY_PREF_LAST_UPDATE_TIME", this.mBrandId, lastUpdateTime);
    }

    public boolean isLastUpdateTimeExists() {
        return this.mPreferenceManager.getLongValue("KEY_PREF_LAST_UPDATE_TIME", this.mBrandId, 0L) == 0L;
    }

    public void shutDown(ShutDownCompletionListener listener) {
        this.mStateMachine.shutDown(listener);
    }

    public void init() {
        if (!this.mStateMachine.isInitialized()) {
            this.mStateMachine.setStateMachineExecutor((IStateMachineExecutor)new StateMachineExecutor(this.mStateMachine.getTag(), (IStateMachine)this.mStateMachine));
        }
    }

    private void notifyHostAppTokenExpired() {
        LPLog.INSTANCE.i(TAG, FlowTags.LOGIN, this.mBrandId + ": notifying host app token expired!");
        LocalBroadcast.sendBroadcast((String)BROADCAST_AMS_TOKEN_EXPIRED);
        this.mController.mEventsProxy.onTokenExpired();
    }

    private void notifyHostAppUserExpired() {
        LPLog.INSTANCE.i(TAG, FlowTags.LOGIN, this.mBrandId + ": notifying host app user expired!");
        this.mController.mEventsProxy.onUnauthenticatedUserExpired();
    }

    private void notifyHostAppCertificateError(String errorMessage) {
        LPLog.INSTANCE.i(TAG, FlowTags.LOGIN, this.mBrandId + ": notifying host app invalid certificate");
        this.mController.mEventsProxy.onError(TaskType.INVALID_CERTIFICATE, errorMessage);
        LocalBroadcast.sendBroadcast((String)BROADCAST_CONNECTING_TO_SERVER_ERROR);
    }

    private void onDisconnected() {
        LPLog.INSTANCE.i(TAG, FlowTags.LOGIN, this.mBrandId + ": disconnected!");
        this.setSocketReady(false);
        this.setIsUpdated(false);
        this.unregisterSocketListener();
        this.mController.getMessagingEventSubscriptionManager().clearAllSubscriptions();
    }

    public boolean isUpdated() {
        return this.mIsUpdated;
    }

    public void setIsUpdated(boolean isUpdated) {
        if (isUpdated != this.mIsUpdated) {
            LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, this.mBrandId + ": setIsUpdated = " + isUpdated);
            this.mIsUpdated = isUpdated;
            this.notifyOnConnectionCompleted(this.mIsUpdated);
            this.proceedOfflineFlow(isUpdated);
        }
    }

    private void notifyOnConnectionCompleted(boolean isUpdated) {
        Bundle connectionBundle = new Bundle();
        connectionBundle.putString(BROADCAST_KEY_BRAND_ID, this.mBrandId);
        connectionBundle.putBoolean(BROADCAST_AMS_CONNECTION_UPDATE_EXTRA, isUpdated);
        LocalBroadcast.sendBroadcast((String)BROADCAST_AMS_CONNECTION_UPDATE_ACTION, (Bundle)connectionBundle);
        this.mController.mEventsProxy.onConnectionChanged(isUpdated);
    }

    private void proceedOfflineFlow(boolean isUpdated) {
        OfflineMessagingManager manager = this.mController.getOfflineManager();
        if (isUpdated) {
            this.mController.amsReadController.registerForegroundConnectionReceiver(this.mBrandId);
            DataBaseExecutor.execute(() -> {
                manager.setFullySynced(true);
                Dialog dialog = this.mController.amsDialogs.getOfflineDialogRepository().queryRealActiveDialog(this.mBrandId);
                if (manager.isSubscribedToActiveDialog() && dialog != null) {
                    manager.getOrCreateOfflineDialog(0L).execute();
                    manager.processOfflineMessages(dialog);
                } else {
                    manager.createNewConversationIfNeeded();
                }
            });
        } else {
            manager.setFullySynced(false);
            manager.setSubscribedToActiveDialog(this.mIsUpdated);
        }
    }

    public boolean isAgentDetailsUpdated() {
        return this.mIsAgentDetailsUpdated;
    }

    public void setAgentDetailsUpdated(boolean updated) {
        this.mIsAgentDetailsUpdated = updated;
    }

    public boolean isFirstNotificationAfterSubscribe() {
        return this.firstNotificationAfterSubscribe;
    }

    public void setFirstNotificationAfterSubscribe(boolean firstNotificationAfterSubscribe) {
        this.firstNotificationAfterSubscribe = firstNotificationAfterSubscribe;
    }

    public class AmsSocketState
    implements SocketStateListener {
        private BaseAmsAccountConnectionCallback callback;
        private LPTraceSpan traceSpan;

        public void onStateChanged(SocketState state) {
            LPLog.INSTANCE.i(AmsConnection.TAG, FlowTags.LOGIN, "onStateChanged with state " + state.name());
            switch (state) {
                case ERROR: 
                case CLOSED: {
                    if (this.callback != null) {
                        LPLog.INSTANCE.i(AmsConnection.TAG, FlowTags.LOGIN, "Notify error to task callback");
                        this.callback.onTaskError(TaskType.OPEN_SOCKET, LpError.SOCKET, new Exception("Open Socket - " + state.name()));
                        this.callback = null;
                    } else {
                        LPLog.INSTANCE.i(AmsConnection.TAG, "Notify socket closed to state machine");
                        AmsConnection.this.onSocketProblem();
                    }
                    if (this.traceSpan == null) break;
                    this.traceSpan.cancel();
                    this.traceSpan = null;
                    break;
                }
                case OPEN: {
                    if (this.callback != null) {
                        LPLog.INSTANCE.i(AmsConnection.TAG, FlowTags.LOGIN, "Notify socket open successfully to task callback");
                        AmsConnectionAnalytics.openSocketTaskEnd();
                        this.callback.onTaskSuccess();
                        this.callback = null;
                    } else {
                        LPLog.INSTANCE.e(AmsConnection.TAG, ErrorCode.ERR_00000145, "Notify socket open successfully but callback is null - CHECK THIS OUT!");
                    }
                    if (this.traceSpan != null) {
                        this.traceSpan.end();
                        this.traceSpan = null;
                    }
                    LocalBroadcast.sendBroadcast((String)AmsConnection.BROADCAST_SOCKET_OPEN_ACTION);
                    AmsConnection.this.getUpdates();
                }
            }
        }

        public void onDisconnected(String reason, int code) {
            LPLog.INSTANCE.i(AmsConnection.TAG, FlowTags.LOGIN, "onDisconnected, reason " + reason + " code " + code);
            if (code == 0) {
                return;
            }
            if (code == 4407 || code == 4401) {
                AmsConnection.this.startDisconnecting();
                AmsConnection.this.notifyHostAppTokenExpired();
            } else if (code == 1200) {
                AmsConnection.this.startDisconnecting();
                AmsConnection.this.notifyHostAppCertificateError(reason);
            } else {
                LPLog.INSTANCE.i(AmsConnection.TAG, FlowTags.LOGIN, "on disconnect:  code " + code + ", Notify socket closed to state machine");
                AmsConnection.this.onSocketProblem();
            }
        }

        public void setCallback(BaseAmsAccountConnectionCallback callback) {
            this.callback = callback;
        }

        public void setTraceSpan(LPTraceSpan traceSpan) {
            this.traceSpan = traceSpan;
        }
    }
}

