/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.utils;

import android.content.Context;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.ConsumerManager;
import com.liveperson.infra.model.Consumer;
import com.liveperson.infra.model.types.FailureReason;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionCallback;
import com.liveperson.messaging.commands.tasks.GetActiveConversationsUmsTask;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.model.SynchronizedAuthenticationCompletedCallback;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eBC\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\rJ&\u0010\u0014\u001a\u00020\u00152\u001c\u0010\u0016\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0018\u0012\b\u0012\u00060\u0019j\u0002`\u001a0\u0017H\u0002J$\u0010\u001b\u001a\u00020\u00152\u001c\u0010\u0016\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0018\u0012\b\u0012\u00060\u0019j\u0002`\u001a0\u0017J&\u0010\u001c\u001a\u00020\u00152\u001c\u0010\u001d\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0018\u0012\b\u0012\u00060\u0019j\u0002`\u001a0\u0017H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/liveperson/messaging/utils/GetActiveConversationsHelper;", "", "context", "Landroid/content/Context;", "mBrandId", "", "lpAuthParams", "Lcom/liveperson/infra/auth/LPAuthenticationParams;", "accountController", "Lcom/liveperson/messaging/controller/AccountsController;", "consumer", "Lcom/liveperson/infra/model/Consumer;", "umsDomain", "(Landroid/content/Context;Ljava/lang/String;Lcom/liveperson/infra/auth/LPAuthenticationParams;Lcom/liveperson/messaging/controller/AccountsController;Lcom/liveperson/infra/model/Consumer;Ljava/lang/String;)V", "getActiveConversationsUmsTask", "Lcom/liveperson/messaging/commands/tasks/GetActiveConversationsUmsTask;", "getGetActiveConversationsUmsTask", "()Lcom/liveperson/messaging/commands/tasks/GetActiveConversationsUmsTask;", "setGetActiveConversationsUmsTask", "(Lcom/liveperson/messaging/commands/tasks/GetActiveConversationsUmsTask;)V", "authorizeAndSendRequest", "", "callback", "Lcom/liveperson/infra/ICallback;", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "checkActiveConversations", "launchGetActiveConversationsUmsTask", "invokerCallback", "Companion", "messaging_release"})
public final class GetActiveConversationsHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String mBrandId;
    @Nullable
    private final LPAuthenticationParams lpAuthParams;
    @NotNull
    private final AccountsController accountController;
    @Nullable
    private final Consumer consumer;
    @Nullable
    private final String umsDomain;
    @Nullable
    private GetActiveConversationsUmsTask getActiveConversationsUmsTask;
    @NotNull
    private static final String TAG = "GetActiveConversationsHelper";

    @JvmOverloads
    public GetActiveConversationsHelper(@NotNull Context context, @NotNull String mBrandId, @Nullable LPAuthenticationParams lpAuthParams, @NotNull AccountsController accountController, @Nullable Consumer consumer, @Nullable String umsDomain) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mBrandId, (String)"mBrandId");
        Intrinsics.checkNotNullParameter((Object)accountController, (String)"accountController");
        this.context = context;
        this.mBrandId = mBrandId;
        this.lpAuthParams = lpAuthParams;
        this.accountController = accountController;
        this.consumer = consumer;
        this.umsDomain = umsDomain;
    }

    public /* synthetic */ GetActiveConversationsHelper(Context context, String string2, LPAuthenticationParams lPAuthenticationParams, AccountsController accountsController, Consumer consumer, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            AccountsController accountsController2 = MessagingFactory.getInstance().getController().mAccountsController;
            Intrinsics.checkNotNullExpressionValue((Object)accountsController2, (String)"getInstance().controller.mAccountsController");
            accountsController = accountsController2;
        }
        if ((n & 0x10) != 0) {
            consumer = Infra.instance.getConsumerManager().getActiveConsumer();
        }
        if ((n & 0x20) != 0) {
            string3 = MessagingFactory.getInstance().getController().mAccountsController.getServiceUrl(string2, "asyncMessagingEnt");
        }
        this(context, string2, lPAuthenticationParams, accountsController, consumer, string3);
    }

    @Nullable
    public final GetActiveConversationsUmsTask getGetActiveConversationsUmsTask() {
        return this.getActiveConversationsUmsTask;
    }

    public final void setGetActiveConversationsUmsTask(@Nullable GetActiveConversationsUmsTask getActiveConversationsUmsTask) {
        this.getActiveConversationsUmsTask = getActiveConversationsUmsTask;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void checkActiveConversations(@NotNull ICallback<List<String>, Exception> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (this.umsDomain != null) {
            Consumer consumer = this.consumer;
            if ((consumer != null ? consumer.getConsumerId() : null) != null) {
                boolean bl;
                String string2 = ConsumerManager.Companion.getConsumerJWT(this.consumer);
                if (string2 != null) {
                    LPAuthenticationParams lPAuthenticationParams = this.lpAuthParams;
                    bl = !string2.equals(lPAuthenticationParams != null ? lPAuthenticationParams.getHostAppJWT() : null);
                } else {
                    bl = false;
                }
                if (!bl) {
                    boolean bl2;
                    Object object = this.consumer.getLpAuthenticationParams();
                    if (object != null && (object = object.getAuthKey()) != null) {
                        LPAuthenticationParams lPAuthenticationParams = this.lpAuthParams;
                        bl2 = !((String)object).equals(lPAuthenticationParams != null ? lPAuthenticationParams.getAuthKey() : null);
                    } else {
                        bl2 = false;
                    }
                    if (!bl2) {
                        this.launchGetActiveConversationsUmsTask(callback);
                        return;
                    }
                }
            }
        }
        this.authorizeAndSendRequest(callback);
    }

    private final void authorizeAndSendRequest(ICallback<List<String>, Exception> callback) {
        boolean isExecuting2 = new SynchronizedAuthenticationCompletedCallback(this.accountController, this.mBrandId, (ICallback<Void, Exception>)((ICallback)new ICallback<Void, Exception>(this, callback){
            final /* synthetic */ GetActiveConversationsHelper this$0;
            final /* synthetic */ ICallback<List<String>, Exception> $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onSuccess(@Nullable Void value) {
                try {
                    GetActiveConversationsHelper.access$launchGetActiveConversationsUmsTask(this.this$0, this.$callback);
                }
                catch (Exception error) {
                    LPLog.INSTANCE.e("TAG", ErrorCode.ERR_000000D9, "sendRequest: Failed to obtain domain/consumerId/token to make request ", (Throwable)error);
                }
            }

            public void onError(@Nullable Exception exception) {
                LPLog.INSTANCE.e("TAG", ErrorCode.ERR_000000DA, "authorizeAndSendRequest: Failed to authorize ", (Throwable)exception);
            }
        })).executeWithReturnValue();
        if (!isExecuting2 && this.lpAuthParams != null) {
            MessagingFactory.getInstance().getController().connectForApiUsage(this.mBrandId, this.lpAuthParams, null, true);
        }
    }

    private final void launchGetActiveConversationsUmsTask(ICallback<List<String>, Exception> invokerCallback) {
        block2: {
            if (this.getActiveConversationsUmsTask == null) {
                this.getActiveConversationsUmsTask = new GetActiveConversationsUmsTask(this.context, this.accountController, this.umsDomain, this.mBrandId);
            }
            GetActiveConversationsUmsTask getActiveConversationsUmsTask = this.getActiveConversationsUmsTask;
            if (getActiveConversationsUmsTask != null) {
                getActiveConversationsUmsTask.setCallback(new BaseAmsAccountConnectionCallback(this, invokerCallback){
                    final /* synthetic */ GetActiveConversationsHelper this$0;
                    final /* synthetic */ ICallback<List<String>, Exception> $invokerCallback;
                    {
                        this.this$0 = $receiver;
                        this.$invokerCallback = $invokerCallback;
                    }

                    public void onTaskSuccess() {
                        List<String> result;
                        GetActiveConversationsUmsTask getActiveConversationsUmsTask = this.this$0.getGetActiveConversationsUmsTask();
                        List<String> list = result = getActiveConversationsUmsTask != null ? getActiveConversationsUmsTask.getResult() : null;
                        if (result != null) {
                            try {
                                this.$invokerCallback.onSuccess(result);
                            }
                            catch (JSONException e) {
                                this.$invokerCallback.onError((Throwable)e);
                            }
                        }
                        LPLog.INSTANCE.d("GetActiveConversationsHelper", "onSuccess");
                    }

                    public void onTaskError(@NotNull TaskType type, @NotNull LpError lpError, @NotNull Exception exception) {
                        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                        Intrinsics.checkNotNullParameter((Object)((Object)lpError), (String)"lpError");
                        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                        LPLog.INSTANCE.d("GetActiveConversationsHelper", "onTaskError");
                        this.$invokerCallback.onError((Throwable)exception);
                    }

                    public void onTaskError(@NotNull TaskType type, @NotNull LpError lpError, @NotNull FailureReason reason, @NotNull Exception exception) {
                        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                        Intrinsics.checkNotNullParameter((Object)((Object)lpError), (String)"lpError");
                        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                        LPLog.INSTANCE.d("GetActiveConversationsHelper", "onTaskError");
                        this.$invokerCallback.onError((Throwable)exception);
                    }

                    public void setSecondaryTask(boolean secondaryTask) {
                        LPLog.INSTANCE.d("GetActiveConversationsHelper", "setSecondaryTask");
                    }
                });
            }
            GetActiveConversationsUmsTask getActiveConversationsUmsTask2 = this.getActiveConversationsUmsTask;
            if (getActiveConversationsUmsTask2 == null) break block2;
            getActiveConversationsUmsTask2.execute();
        }
    }

    @JvmOverloads
    public GetActiveConversationsHelper(@NotNull Context context, @NotNull String mBrandId, @Nullable LPAuthenticationParams lpAuthParams, @NotNull AccountsController accountController, @Nullable Consumer consumer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mBrandId, (String)"mBrandId");
        Intrinsics.checkNotNullParameter((Object)accountController, (String)"accountController");
        this(context, mBrandId, lpAuthParams, accountController, consumer, null, 32, null);
    }

    @JvmOverloads
    public GetActiveConversationsHelper(@NotNull Context context, @NotNull String mBrandId, @Nullable LPAuthenticationParams lpAuthParams, @NotNull AccountsController accountController) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mBrandId, (String)"mBrandId");
        Intrinsics.checkNotNullParameter((Object)accountController, (String)"accountController");
        this(context, mBrandId, lpAuthParams, accountController, null, null, 48, null);
    }

    @JvmOverloads
    public GetActiveConversationsHelper(@NotNull Context context, @NotNull String mBrandId, @Nullable LPAuthenticationParams lpAuthParams) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mBrandId, (String)"mBrandId");
        this(context, mBrandId, lpAuthParams, null, null, null, 56, null);
    }

    public static final /* synthetic */ void access$launchGetActiveConversationsUmsTask(GetActiveConversationsHelper $this, ICallback invokerCallback) {
        $this.launchGetActiveConversationsUmsTask((ICallback<List<String>, Exception>)invokerCallback);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/messaging/utils/GetActiveConversationsHelper$Companion;", "", "()V", "TAG", "", "messaging_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

