package com.liveperson.messaging.wm.core

import android.content.ContentValues
import android.content.SharedPreferences

/**
 * Implementation of multi-process shared preferences.
 *
 * @param editorHelper component used to write/delete values to preferences.
 * @param valueReader component used to query values from preferences.
 */
class MultiProcessStore(
    private val editorHelper: MultiProcessEditorHelper,
    private val valueReader: ValueReader
): SharedPreferences {
    override fun getAll(): MutableMap<String, *> = valueReader.getAllValues()

    override fun getString(key: String, defValue: String?): String? = valueReader.readValue(key, defValue)

    override fun getStringSet(key: String, defValues: MutableSet<String>?): MutableSet<String>? = valueReader.readValue(key, defValues)

    override fun getInt(key: String, defValue: Int): Int = valueReader.readValue(key, defValue)

    override fun getLong(key: String, defValue: Long): Long = valueReader.readValue(key, defValue)

    override fun getFloat(key: String, defValue: Float): Float = valueReader.readValue(key, defValue)

    override fun getBoolean(key: String, defValue: Boolean): Boolean = valueReader.readValue(key, defValue)

    override fun contains(key: String): Boolean = valueReader.containsValue(key)

    override fun edit(): SharedPreferences.Editor = MultiProcessEditor(ContentValues(), editorHelper)

    override fun registerOnSharedPreferenceChangeListener(listener: SharedPreferences.OnSharedPreferenceChangeListener) = Unit

    override fun unregisterOnSharedPreferenceChangeListener(listener: SharedPreferences.OnSharedPreferenceChangeListener) = Unit
}