/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.hybrid.commands.messaging;

import com.liveperson.infra.ICallback;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.hybrid.HybridSDKUtils;
import com.liveperson.messaging.hybrid.commands.base.HybridSDKCommand;
import com.liveperson.messaging.hybrid.commands.exceptions.EmptyMessageException;
import com.liveperson.messaging.hybrid.commands.exceptions.HybridSDKException;
import com.liveperson.messaging.hybrid.commands.messaging.DelegatedCommandCallback;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J$\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/liveperson/messaging/hybrid/commands/messaging/SendMessageHybridSDKCommand;", "Lcom/liveperson/messaging/hybrid/commands/base/HybridSDKCommand;", "", "message", "", "(Ljava/lang/String;)V", "execute", "messaging", "Lcom/liveperson/messaging/Messaging;", "callback", "Lcom/liveperson/infra/ICallback;", "Lcom/liveperson/messaging/hybrid/commands/exceptions/HybridSDKException;", "messaging_release"})
public final class SendMessageHybridSDKCommand
implements HybridSDKCommand<Unit> {
    @NotNull
    private final String message;

    public SendMessageHybridSDKCommand(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.message = message;
    }

    @Override
    public void execute(@NotNull Messaging messaging, @NotNull ICallback<Unit, HybridSDKException> callback) {
        Intrinsics.checkNotNullParameter((Object)messaging, (String)"messaging");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        String string2 = HybridSDKUtils.requireStateToSendMessage(messaging).getActiveBrandId();
        Intrinsics.checkNotNull((Object)string2);
        String brandId = string2;
        if (((CharSequence)this.message).length() == 0) {
            callback.onError((Throwable)new EmptyMessageException("Sent message shouldn't be empty"));
            return;
        }
        messaging.sendMessage(brandId, brandId, this.message, null, new DelegatedCommandCallback(callback));
    }
}

