package com.liveperson.messaging.hybrid.commands.messaging

import com.liveperson.infra.CommandCallback
import com.liveperson.infra.ICallback
import com.liveperson.messaging.hybrid.commands.exceptions.HybridSDKException
import com.liveperson.messaging.hybrid.commands.exceptions.InternalHybridSDKException

/**
 * Internal wrapper for command callback to execute any internal sdk commands and populate a result
 * using [ICallback]. [ICallback] is a public callback used by brand's app to receive a result
 * of LivePerson SDK API call invocation.
 */
internal class DelegatedCommandCallback constructor(val callback: ICallback<Unit, HybridSDKException>): CommandCallback {

    override fun onSuccess() {
        callback.onSuccess(Unit)
    }

    override fun onFailure(throwable: Throwable) {
        if (throwable is HybridSDKException) {
            callback.onError(throwable)
        } else {
            callback.onError(InternalHybridSDKException(message = "Internal error occurred", cause = throwable))
        }

    }
}