/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging;

import android.content.Context;
import com.liveperson.infra.PushUnregisterType;
import com.liveperson.infra.preferences.PushMessagePreferences;
import com.liveperson.infra.statemachine.InitProcess;
import com.liveperson.infra.statemachine.LogoutProcess;
import com.liveperson.infra.statemachine.ShutDownProcess;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingInitData;

public class MessagingFactory {
    protected static MessagingFactory instance;
    protected Messaging messagingController;

    protected MessagingFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessagingFactory getInstance() {
        if (instance != null) return instance;
        Class<MessagingFactory> clazz = MessagingFactory.class;
        synchronized (MessagingFactory.class) {
            if (instance != null) return instance;
            instance = new MessagingFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void init(Context context, MessagingInitData initData, InitProcess initProcess) {
        this.initializeMessaging();
        this.messagingController.init(context, initData, initProcess);
    }

    private void initializeMessaging() {
        if (this.messagingController == null) {
            this.messagingController = new Messaging();
        }
    }

    public Messaging getController() {
        return this.messagingController;
    }

    public void shutDown(ShutDownProcess shutDownProcess) {
        this.messagingController.shutDown(shutDownProcess);
    }

    public void logout(Context context, MessagingInitData initData, boolean forceLogOut, PushUnregisterType type, LogoutProcess logoutProcess) {
        this.initializeMessaging();
        this.messagingController.logout(context, initData, forceLogOut, type, logoutProcess);
    }

    public boolean isInitialized() {
        return this.messagingController.isInitialized();
    }

    public void initAnalyticsService(Context applicationContext, String brandId, String appId) {
        this.initializeMessaging();
        this.messagingController.initAnalyticsService(applicationContext, brandId, appId);
    }

    public void setPushNotificationTapped(String pushMessageId) {
        PushMessagePreferences.INSTANCE.setPushMessageClicked(pushMessageId, true);
    }

    public void setPushNotificationTapped(String pushMessageId, boolean clearOthers) {
        PushMessagePreferences.INSTANCE.setPushMessageClicked(pushMessageId, true);
        PushMessagePreferences.INSTANCE.setClearOthers(clearOthers);
    }
}

