/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.pusher;

import android.content.Context;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.PushMessage;
import com.liveperson.infra.utils.PushMessageParser;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.pusher.PusherHelper;
import com.liveperson.messaging.model.SynchronizedAuthenticationCompletedCallback;
import com.liveperson.messaging.model.SynchronizedInternetConnectionCallback;
import com.liveperson.messaging.network.http.GetPendingProactiveMessagesRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dBC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u001c\u0010\t\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\u0012\u00060\rj\u0002`\u000e0\n\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0014\u0010\u0015\u001a\u00020\u00132\n\u0010\u0016\u001a\u00060\rj\u0002`\u000eH\u0002J\u0016\u0010\u0017\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\u0012\u00060\rj\u0002`\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/liveperson/messaging/commands/pusher/GetPendingProactiveMessagesCommand;", "Lcom/liveperson/infra/Command;", "controller", "Lcom/liveperson/messaging/Messaging;", "brandId", "", "appId", "authParams", "Lcom/liveperson/infra/auth/LPAuthenticationParams;", "callback", "Lcom/liveperson/infra/ICallback;", "", "Lcom/liveperson/infra/model/PushMessage;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Lcom/liveperson/messaging/Messaging;Ljava/lang/String;Ljava/lang/String;Lcom/liveperson/infra/auth/LPAuthenticationParams;Lcom/liveperson/infra/ICallback;)V", "mPusherHelper", "Lcom/liveperson/messaging/commands/pusher/PusherHelper;", "authorizeAndSendRequest", "", "execute", "notifyError", "exception", "notifySuccess", "pushMessages", "parseResponse", "jsonString", "sendRequest", "validateNetworkState", "Companion", "messaging_release"})
public final class GetPendingProactiveMessagesCommand
implements Command {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Messaging controller;
    @NotNull
    private final String brandId;
    @NotNull
    private final String appId;
    @NotNull
    private final LPAuthenticationParams authParams;
    @NotNull
    private final ICallback<List<PushMessage>, Exception> callback;
    @Nullable
    private PusherHelper mPusherHelper;
    @NotNull
    private static final String TAG = "GetPendingProactiveMessagesCommand";
    @NotNull
    private static final String ERROR_UNABLE_TO_MAKE_REQUEST = "Unable to GetPendingProactiveMessagesCommand.";
    private static final int LIMIT = 50;
    @NotNull
    private static final String URL = "https://%1$s/api/account/%2$s/proactive/pending-messages?appId=%3$s&consumerId=%4$s&os=android&v=1&limit=%5$s";

    public GetPendingProactiveMessagesCommand(@NotNull Messaging controller, @NotNull String brandId, @NotNull String appId, @NotNull LPAuthenticationParams authParams, @NotNull ICallback<List<PushMessage>, Exception> callback) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)authParams, (String)"authParams");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.controller = controller;
        this.brandId = brandId;
        this.appId = appId;
        this.authParams = authParams;
        this.callback = callback;
    }

    public void execute() {
        CharSequence charSequence = this.appId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            String exceptionMsg = "Unable to GetPendingProactiveMessagesCommand. Error: Missing appID";
            this.callback.onError((Throwable)new Exception(exceptionMsg));
            this.notifyError(new Exception(exceptionMsg));
            return;
        }
        this.mPusherHelper = new PusherHelper(this.brandId, this.controller);
        this.validateNetworkState();
    }

    private final void validateNetworkState() {
        if (InternetConnectionService.isNetworkAvailable()) {
            this.authorizeAndSendRequest();
        } else {
            new SynchronizedInternetConnectionCallback(() -> GetPendingProactiveMessagesCommand.validateNetworkState$lambda-0(this)).execute();
        }
    }

    private final void authorizeAndSendRequest() {
        boolean isExecuting2 = new SynchronizedAuthenticationCompletedCallback(this.controller.mAccountsController, this.brandId, (ICallback<Void, Exception>)((ICallback)new ICallback<Void, Exception>(this){
            final /* synthetic */ GetPendingProactiveMessagesCommand this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@Nullable Void value) {
                LPLog.INSTANCE.d("GetPendingProactiveMessagesCommand", "onSuccess");
                GetPendingProactiveMessagesCommand.access$sendRequest(this.this$0);
            }

            public void onError(@Nullable Exception exception) {
                LPLog.INSTANCE.e("GetPendingProactiveMessagesCommand", ErrorCode.ERR_0000016G, "Failed when execute SynchronizedAuthenticationCompletedCallback");
                Exception exception2 = exception;
                if (exception2 == null) {
                    exception2 = new Exception("Failed when execute SynchronizedAuthenticationCompletedCallback");
                }
                GetPendingProactiveMessagesCommand.access$notifyError(this.this$0, exception2);
            }
        })).executeWithReturnValue();
        if (!isExecuting2) {
            this.controller.connectForApiUsage(this.brandId, this.authParams, null, true);
        }
    }

    private final void sendRequest() {
        if (this.mPusherHelper == null) {
            this.mPusherHelper = new PusherHelper(this.brandId, this.controller);
        }
        PusherHelper pusherHelper = this.mPusherHelper;
        String pusherDomain = pusherHelper != null ? pusherHelper.getPusherDomain() : null;
        CharSequence charSequence = pusherDomain;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            this.notifyError(new Exception("Unable to GetPendingProactiveMessagesCommand. Error: Missing Domain"));
            return;
        }
        PusherHelper pusherHelper2 = this.mPusherHelper;
        String consumerId = pusherHelper2 != null ? pusherHelper2.getConsumerId() : null;
        CharSequence charSequence2 = consumerId;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            this.notifyError(new Exception("Unable to GetPendingProactiveMessagesCommand. Error: Missing consumerID"));
            return;
        }
        PusherHelper pusherHelper3 = this.mPusherHelper;
        String token = pusherHelper3 != null ? pusherHelper3.getAuthToken() : null;
        CharSequence charSequence3 = token;
        if (charSequence3 == null || StringsKt.isBlank((CharSequence)charSequence3)) {
            this.notifyError(new Exception("Unable to GetPendingProactiveMessagesCommand. Error: Missing auth token"));
            return;
        }
        PusherHelper pusherHelper4 = this.mPusherHelper;
        List<String> certificates = pusherHelper4 != null ? pusherHelper4.getCertificatePinningKeys() : null;
        String string2 = URL;
        Object[] objectArray = new Object[]{pusherDomain, this.brandId, this.appId, consumerId, 50};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        String url = string3;
        new GetPendingProactiveMessagesRequest(url, token, certificates, (ICallback<String, Exception>)((ICallback)new ICallback<String, Exception>(this){
            final /* synthetic */ GetPendingProactiveMessagesCommand this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@Nullable String value) {
                CharSequence charSequence = value;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    List pushMessages = GetPendingProactiveMessagesCommand.access$parseResponse(this.this$0, value);
                    GetPendingProactiveMessagesCommand.access$notifySuccess(this.this$0, pushMessages);
                } else {
                    GetPendingProactiveMessagesCommand.access$notifyError(this.this$0, new Exception("null response"));
                }
            }

            public void onError(@Nullable Exception exception) {
                Exception exception2 = exception;
                if (exception2 == null) {
                    exception2 = new Exception("Unable to GetPendingProactiveMessagesCommand.");
                }
                GetPendingProactiveMessagesCommand.access$notifyError(this.this$0, exception2);
            }
        })).execute();
    }

    private final List<PushMessage> parseResponse(String jsonString) {
        ArrayList arrayList = PushMessageParser.parsePendingProactiveMessages((String)this.brandId, (Context)this.controller.getApplicationContext(), (String)jsonString);
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"parsePendingProactiveMes\u2026ationContext, jsonString)");
        ArrayList pushMessages = arrayList;
        return pushMessages;
    }

    private final void notifySuccess(List<? extends PushMessage> pushMessages) {
        Infra.instance.postOnMainThread(() -> GetPendingProactiveMessagesCommand.notifySuccess$lambda-1(this, pushMessages));
    }

    private final void notifyError(Exception exception) {
        String string2 = exception.getMessage();
        Intrinsics.checkNotNull((Object)string2);
        LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000016G, string2);
        Infra.instance.postOnMainThread(() -> GetPendingProactiveMessagesCommand.notifyError$lambda-2(exception, this));
    }

    private static final void validateNetworkState$lambda-0(GetPendingProactiveMessagesCommand this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.authorizeAndSendRequest();
    }

    private static final void notifySuccess$lambda-1(GetPendingProactiveMessagesCommand this$0, List $pushMessages) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$pushMessages, (String)"$pushMessages");
        this$0.callback.onSuccess((Object)$pushMessages);
    }

    private static final void notifyError$lambda-2(Exception $exception, GetPendingProactiveMessagesCommand this$0) {
        Intrinsics.checkNotNullParameter((Object)$exception, (String)"$exception");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($exception instanceof SSLPeerUnverifiedException) {
            this$0.controller.mEventsProxy.onError(LpError.INVALID_CERTIFICATE, $exception.getMessage());
        }
        this$0.callback.onError((Throwable)$exception);
    }

    public static final /* synthetic */ void access$sendRequest(GetPendingProactiveMessagesCommand $this) {
        $this.sendRequest();
    }

    public static final /* synthetic */ void access$notifyError(GetPendingProactiveMessagesCommand $this, Exception exception) {
        $this.notifyError(exception);
    }

    public static final /* synthetic */ List access$parseResponse(GetPendingProactiveMessagesCommand $this, String jsonString) {
        return $this.parseResponse(jsonString);
    }

    public static final /* synthetic */ void access$notifySuccess(GetPendingProactiveMessagesCommand $this, List pushMessages) {
        $this.notifySuccess(pushMessages);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/liveperson/messaging/commands/pusher/GetPendingProactiveMessagesCommand$Companion;", "", "()V", "ERROR_UNABLE_TO_MAKE_REQUEST", "", "LIMIT", "", "TAG", "URL", "messaging_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

