/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.controller.connection;

import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.utils.VersionUtils;
import com.liveperson.messaging.controller.connection.IConnectionParamsCache;
import com.liveperson.monitoring.MonitoringFactory;
import java.util.HashMap;

public class ConnectionParamsCache
implements IConnectionParamsCache {
    private static final String TAG = "ConnectionParamsCache";
    public static final String CSDS_UMS_DOMAIN_KEY = "asyncMessagingEnt";
    public static final String CSDS_AMS_TOKENIZER_DOMAIN_KEY = "tokenizer";
    public static final String CSDS_IDP_DOMAIN_KEY = "idp";
    public static final String CSDS_PUSHER_DOMAIN_KEY = "pusher";
    public static final String CSDS_AC_CDN_DOMAIN_KEY = "acCdnDomain";
    public static final String CSDS_AC_CDN_DOMAIN_CONSUMER_SDK_KEY = "acCdnDomainConsumerSdk";
    public static final String CSDS_LE_CDN_DOMAIN_KEY = "leCdnDomain";
    public static final String CSDS_SWIFT_DOMAIN_KEY = "swift";
    public static final String CSDS_INCA_KEY = "msgHist";
    public static final String CSDS_EVENT_MANAGER_DOMAIN_KEY = "eventManager";
    public static final String CSDS_OTEL_CONSUMER_SDK_KEY = "otelDomainConsumerSdk";
    public static final String AC_CDN_VERSION_KEY = "ac_cdn_version_key";
    public static final String LE_CDN_VERSION_KEY = "le_cdn_version_key";
    public static final String FULL_CONNECTION_FLOW_REQUIRED_KEY = "full_connection_flow_required_key";
    public static final String AUTO_MESSAGES_ENABLED_KEY = "auto_messages_enabled_key";
    private final String mBrandId;
    private String mCsdsUmsDomain;
    private String mCsdsTokenizerDomain;
    private String mCsdsIdpDomain;
    private String mCsdsPusherDomain;
    private String mCsdsAcCdnDomain;
    private String mCsdsLeCdnDomain;
    private String mCsdsSwiftDomain;
    private String mIncaDomain;
    private String mCsdsEventManagerDomain;
    private String mCsdsOtelConsumerSdkDomain;
    private String mAcCdnSdkMinVersion;
    private String mLeCdnSdkMinVersion;
    private boolean mFullConnectionFlowRequired;
    private boolean mAutoMessagesFeatureEnabled;
    private boolean isConnectionForApiUsage;

    public ConnectionParamsCache(String brandId) {
        this.mBrandId = brandId;
        this.mCsdsUmsDomain = PreferenceManager.getInstance().getStringValue(CSDS_UMS_DOMAIN_KEY, this.mBrandId, null);
        this.mCsdsTokenizerDomain = PreferenceManager.getInstance().getStringValue(CSDS_AMS_TOKENIZER_DOMAIN_KEY, this.mBrandId, null);
        this.mCsdsIdpDomain = PreferenceManager.getInstance().getStringValue(CSDS_IDP_DOMAIN_KEY, this.mBrandId, null);
        this.mCsdsPusherDomain = PreferenceManager.getInstance().getStringValue(CSDS_PUSHER_DOMAIN_KEY, this.mBrandId, null);
        this.mCsdsAcCdnDomain = PreferenceManager.getInstance().getStringValue(CSDS_AC_CDN_DOMAIN_KEY, this.mBrandId, null);
        this.mCsdsLeCdnDomain = PreferenceManager.getInstance().getStringValue(CSDS_LE_CDN_DOMAIN_KEY, this.mBrandId, null);
        this.mCsdsSwiftDomain = PreferenceManager.getInstance().getStringValue(CSDS_SWIFT_DOMAIN_KEY, this.mBrandId, null);
        this.mIncaDomain = PreferenceManager.getInstance().getStringValue(CSDS_INCA_KEY, this.mBrandId, null);
        this.mCsdsEventManagerDomain = PreferenceManager.getInstance().getStringValue(CSDS_EVENT_MANAGER_DOMAIN_KEY, this.mBrandId, null);
        this.mCsdsOtelConsumerSdkDomain = PreferenceManager.getInstance().getStringValue(CSDS_OTEL_CONSUMER_SDK_KEY, this.mBrandId, null);
        this.mAcCdnSdkMinVersion = PreferenceManager.getInstance().getStringValue(AC_CDN_VERSION_KEY, this.mBrandId, null);
        this.mLeCdnSdkMinVersion = PreferenceManager.getInstance().getStringValue(LE_CDN_VERSION_KEY, this.mBrandId, null);
        this.mFullConnectionFlowRequired = PreferenceManager.getInstance().getBooleanValue(FULL_CONNECTION_FLOW_REQUIRED_KEY, this.mBrandId, true);
        this.mAutoMessagesFeatureEnabled = PreferenceManager.getInstance().getBooleanValue(AUTO_MESSAGES_ENABLED_KEY, this.mBrandId, false);
    }

    @Override
    public boolean updateCsdsDomains(HashMap<String, String> csdsDomains) {
        boolean updated = false;
        if (csdsDomains == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000000F, "updateCsdsDomains: domains received are null");
            return false;
        }
        if (this.updateDomain(csdsDomains, CSDS_UMS_DOMAIN_KEY, this.mCsdsUmsDomain)) {
            updated = true;
        }
        if (this.updateDomain(csdsDomains, CSDS_AMS_TOKENIZER_DOMAIN_KEY, this.mCsdsTokenizerDomain)) {
            updated = true;
        }
        if (this.updateDomain(csdsDomains, CSDS_IDP_DOMAIN_KEY, this.mCsdsIdpDomain)) {
            updated = true;
        }
        if (this.updateDomain(csdsDomains, CSDS_PUSHER_DOMAIN_KEY, this.mCsdsPusherDomain)) {
            updated = true;
        }
        if (this.updateAcCdnDomain(csdsDomains, this.mCsdsAcCdnDomain)) {
            updated = true;
        }
        if (this.updateDomain(csdsDomains, CSDS_LE_CDN_DOMAIN_KEY, this.mCsdsLeCdnDomain)) {
            updated = true;
        }
        if (this.updateDomain(csdsDomains, CSDS_SWIFT_DOMAIN_KEY, this.mCsdsSwiftDomain)) {
            updated = true;
        }
        if (this.updateDomain(csdsDomains, CSDS_INCA_KEY, this.mIncaDomain)) {
            updated = true;
        }
        if (this.updateDomain(csdsDomains, CSDS_EVENT_MANAGER_DOMAIN_KEY, this.mCsdsEventManagerDomain)) {
            updated = true;
        }
        if (this.updateDomain(csdsDomains, CSDS_OTEL_CONSUMER_SDK_KEY, this.mCsdsOtelConsumerSdkDomain)) {
            updated = true;
        }
        if (MonitoringFactory.INSTANCE.isInitialized()) {
            MonitoringFactory.INSTANCE.getMonitoring().getParamsCache().updateCsdsDomains(csdsDomains);
        }
        return updated;
    }

    private boolean updateAcCdnDomain(HashMap<String, String> csdsDomains, String oldDomainValue) {
        String domainGCP;
        boolean updated = false;
        if (csdsDomains.containsKey(CSDS_AC_CDN_DOMAIN_CONSUMER_SDK_KEY) && (domainGCP = csdsDomains.get(CSDS_AC_CDN_DOMAIN_CONSUMER_SDK_KEY)) != null && !domainGCP.isEmpty()) {
            PreferenceManager.getInstance().setStringValue(CSDS_AC_CDN_DOMAIN_KEY, this.mBrandId, domainGCP);
            this.mCsdsAcCdnDomain = domainGCP;
            if (oldDomainValue != null && !domainGCP.equals(oldDomainValue)) {
                updated = true;
            }
            return updated;
        }
        updated = this.updateDomain(csdsDomains, CSDS_AC_CDN_DOMAIN_KEY, oldDomainValue);
        return updated;
    }

    @Override
    public void updateAcCdnVersion(String newVersion) {
        if (newVersion != null) {
            PreferenceManager.getInstance().setStringValue(AC_CDN_VERSION_KEY, this.mBrandId, newVersion);
            this.mAcCdnSdkMinVersion = newVersion;
        }
    }

    @Override
    public void updateLeCdnVersion(String newVersion) {
        if (newVersion != null) {
            PreferenceManager.getInstance().setStringValue(LE_CDN_VERSION_KEY, this.mBrandId, newVersion);
            this.mLeCdnSdkMinVersion = newVersion;
        }
    }

    @Override
    public boolean isCsdsFilled() {
        return this.mCsdsUmsDomain != null && this.mCsdsTokenizerDomain != null && this.mCsdsIdpDomain != null && this.mCsdsPusherDomain != null && this.mCsdsAcCdnDomain != null && this.mCsdsLeCdnDomain != null && this.mIncaDomain != null;
    }

    @Override
    public String getServiceDomain(String serviceName) {
        String domainToReturn = null;
        switch (serviceName) {
            case "asyncMessagingEnt": {
                domainToReturn = this.mCsdsUmsDomain;
                break;
            }
            case "tokenizer": {
                domainToReturn = this.mCsdsTokenizerDomain;
                break;
            }
            case "idp": {
                domainToReturn = this.mCsdsIdpDomain;
                break;
            }
            case "pusher": {
                domainToReturn = this.mCsdsPusherDomain;
                break;
            }
            case "acCdnDomain": {
                domainToReturn = this.mCsdsAcCdnDomain;
                break;
            }
            case "leCdnDomain": {
                domainToReturn = this.mCsdsLeCdnDomain;
                break;
            }
            case "swift": {
                domainToReturn = this.mCsdsSwiftDomain;
                break;
            }
            case "msgHist": {
                domainToReturn = this.mIncaDomain;
                break;
            }
            case "eventManager": {
                domainToReturn = this.mCsdsEventManagerDomain;
                break;
            }
            case "otelDomainConsumerSdk": {
                domainToReturn = this.mCsdsOtelConsumerSdkDomain;
            }
        }
        return domainToReturn;
    }

    @Override
    public boolean isVersionsCompatible() {
        return this.mLeCdnSdkMinVersion == null || this.mAcCdnSdkMinVersion == null || VersionUtils.isValidSdkVersion((String)this.mAcCdnSdkMinVersion) && VersionUtils.isValidSdkVersion((String)this.mLeCdnSdkMinVersion);
    }

    @Override
    public boolean isFullConnectionFlowRequired() {
        return this.mFullConnectionFlowRequired;
    }

    @Override
    public void setFullConnectionFlowRequired(boolean fullConnectionFlowRequired) {
        this.mFullConnectionFlowRequired = fullConnectionFlowRequired;
        PreferenceManager.getInstance().setBooleanValue(FULL_CONNECTION_FLOW_REQUIRED_KEY, this.mBrandId, fullConnectionFlowRequired);
    }

    @Override
    public boolean isAutoMessagesFeatureEnabled() {
        return this.mAutoMessagesFeatureEnabled;
    }

    @Override
    public void setAutoMessagesFeatureEnabled(boolean autoMessagesFeatureEnabled) {
        this.mAutoMessagesFeatureEnabled = autoMessagesFeatureEnabled;
        PreferenceManager.getInstance().setBooleanValue(AUTO_MESSAGES_ENABLED_KEY, this.mBrandId, autoMessagesFeatureEnabled);
    }

    @Override
    public boolean isConnectionForApiUsage() {
        return this.isConnectionForApiUsage;
    }

    @Override
    public void setConnectionForApiUsage(boolean connectionForApiUsage) {
        this.isConnectionForApiUsage = connectionForApiUsage;
    }

    private boolean updateDomain(HashMap<String, String> csdsDomains, String csdsDomainKey, String oldDomainValue) {
        boolean updated = false;
        String domain = csdsDomains.get(csdsDomainKey);
        if (domain != null) {
            PreferenceManager.getInstance().setStringValue(csdsDomainKey, this.mBrandId, domain);
            if (oldDomainValue != null && !domain.equals(oldDomainValue)) {
                updated = true;
            }
            switch (csdsDomainKey) {
                case "asyncMessagingEnt": {
                    this.mCsdsUmsDomain = domain;
                    break;
                }
                case "tokenizer": {
                    this.mCsdsTokenizerDomain = domain;
                    break;
                }
                case "idp": {
                    this.mCsdsIdpDomain = domain;
                    break;
                }
                case "pusher": {
                    this.mCsdsPusherDomain = domain;
                    break;
                }
                case "acCdnDomain": {
                    this.mCsdsAcCdnDomain = domain;
                    break;
                }
                case "leCdnDomain": {
                    this.mCsdsLeCdnDomain = domain;
                    break;
                }
                case "swift": {
                    this.mCsdsSwiftDomain = domain;
                    break;
                }
                case "msgHist": {
                    this.mIncaDomain = domain;
                    break;
                }
                case "eventManager": {
                    this.mCsdsEventManagerDomain = domain;
                    break;
                }
                case "otelDomainConsumerSdk": {
                    this.mCsdsOtelConsumerSdkDomain = domain;
                }
            }
        }
        return updated;
    }
}

