/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.hybrid;

import com.liveperson.infra.ICallback;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.hybrid.HybridSDKUtils;
import com.liveperson.messaging.hybrid.commands.base.HybridSDKCommand;
import com.liveperson.messaging.hybrid.commands.exceptions.HybridSDKException;
import com.liveperson.messaging.hybrid.commands.exceptions.InternalHybridSDKException;
import com.liveperson.messaging.hybrid.commands.messaging.SendMessageHybridSDKCommand;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a.\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00070\u0006\u001a\"\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\u000b"}, d2={"execute", "", "T", "command", "Lcom/liveperson/messaging/hybrid/commands/base/HybridSDKCommand;", "callback", "Lcom/liveperson/infra/ICallback;", "Lcom/liveperson/messaging/hybrid/commands/exceptions/HybridSDKException;", "sendMessage", "message", "", "messaging_release"})
@JvmName(name="MessagingCommands")
public final class MessagingCommands {
    public static final <T> void execute(@NotNull HybridSDKCommand<T> command, @NotNull ICallback<T, HybridSDKException> callback) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        try {
            Messaging messaging = HybridSDKUtils.requireInitialization(MessagingFactory.getInstance().getController());
            command.execute(messaging, callback);
        }
        catch (HybridSDKException throwable) {
            callback.onError((Throwable)throwable);
        }
        catch (Exception throwable) {
            callback.onError((Throwable)new InternalHybridSDKException("Internal error", throwable));
        }
    }

    public static final void sendMessage(@NotNull String message, @NotNull ICallback<Unit, HybridSDKException> callback) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        MessagingCommands.execute(new SendMessageHybridSDKCommand(message), callback);
    }
}

