package com.liveperson.api.response.types;

import android.text.TextUtils;

import com.liveperson.infra.log.LPLog;

import static com.liveperson.infra.errors.ErrorCode.ERR_00000060;

public enum DialogType {
    MAIN, POST_SURVEY, AGENT, OTHER;

    private static final String TAG = "DialogType";

    public static DialogType parse(int ordinal) {
        DialogType result = MAIN;

        DialogType[] values = DialogType.values();
        if (ordinal < values.length) {
            result = values[ordinal];
        }

        return result;
    }

    public static DialogType parse(String dialogTypeString) {
        DialogType result = MAIN;
        if (TextUtils.isEmpty(dialogTypeString)) return result;

        try {
            result = DialogType.valueOf(dialogTypeString);
        } catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ERR_00000060, "Failed to parse DialogType from string: " + dialogTypeString, e);
            DialogType[] values = values();
            for (DialogType dialogType : values) {
                if (dialogType.name().equalsIgnoreCase(dialogTypeString)) {
                    result = dialogType;
                    break;
                }
            }
        }

        return result;
    }
}
