package com.liveperson.messaging.network.http;

import android.net.Uri;

import com.liveperson.api.response.model.QueryParams;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.body.HttpImageRequestBody;
import com.liveperson.infra.network.http.body.HttpRequestBody;
import com.liveperson.infra.network.http.request.HttpPutRequest;
import com.liveperson.infra.otel.LPTraceType;

import java.util.List;

public class UploadFileRequest implements Command {

    private static final String TAG = "UploadFileRequest";
    private String mRelativePath;
    private QueryParams mQueryParams;
    private ICallback<Object, Throwable> mCallback;
    private String mDomain;
    private byte[] mBitmap;
    private List<String> mCertificates;
    private int mUploadTimeout = 30000;

    public UploadFileRequest(String domain, String relativePath, QueryParams queryParams, List<String> certificates, ICallback<Object, Throwable> callback, byte[] bitmap, Integer uploadTimeout) {
        mRelativePath = relativePath;
        mQueryParams = queryParams;
        mCallback = callback;
        mDomain = domain;
		mBitmap = bitmap;
        mCertificates = certificates;
		if (uploadTimeout != null) {
			mUploadTimeout = uploadTimeout;
		}
	}


    /**
     * Execute request
     */
    @Override
    public void execute() {

        Uri.Builder builder = new Uri.Builder();
		builder.scheme("https");
		builder.path(mDomain+ mRelativePath);
		mQueryParams.appendQueryParameter(builder);

		HttpPutRequest httpPutRequest = new HttpPutRequest(builder.build().toString(),
                LPTraceType.PUSHER_CLEAR_BADGE_COUNT_REQ);
		HttpRequestBody body = new HttpImageRequestBody() {
			@Override
			public byte[] get() {
				return mBitmap;
			}

			@Override
			public String getContentType() {
				return "text/plain";// TODO: 7/19/16 change this to multipart or dynamic...
			}
		};
		httpPutRequest.setBody(body);
		httpPutRequest.setCertificatePinningKeys(mCertificates);
		httpPutRequest.setTimeout(mUploadTimeout);
		LPLog.INSTANCE.d(TAG, "Sending upload file to swift with timeout: " + mUploadTimeout);
        httpPutRequest.setCallback( new ICallback<String, Exception>() {

            @Override
            public void onSuccess(String body) {
                mCallback.onSuccess(body);
            }

            @Override
            public void onError(Exception exception) {
                mCallback.onError(exception);
            }
        });
        HttpHandler.execute(httpPutRequest);
    }


}
