/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.request;

import com.liveperson.api.request.AbstractRequest;
import com.liveperson.api.response.model.MultiDialog;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.CsatStatus;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.api.response.types.DialogType;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.ConversationField;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UpdateConversationField
extends AbstractRequest {
    public static final String CONVERSATION_STAGE_FIELD = "Stage";
    @Deprecated
    private static final String CONVERSATION_STATE_FIELD = "ConversationStateField";
    public static final String CONVERSATION_CSAT_RATE = "CSATRate";
    public static final String TTR_FIELD = "TTRField";
    public static final String UPDATE_CONVERSATION_FIELD_TYPE = "cm.UpdateConversationField";
    private static final String UPDATE = "UPDATE";
    public static final String CONVERSATION_ID = "conversationId";
    public static final String FIELD = "field";
    private static final String TYPE = "type";
    private static final String USER_ID = "userId";
    private static final String ROLE = "role";
    private static final String DIALOG = "dialog";
    private static final String DIALOG_ID = "dialogId";
    private static final String DIALOG_TYPE = "dialogType";
    private static final String DIALOG_CHANNEL_TYPE = "channelType";
    private static final String COBROWSE_DIALOG_METADATA = "metaData";
    private static final String STATE = "state";
    private static final String CLOSED_BY = "closedBy";
    @Deprecated
    public static final String CONVERSATION_STATE = "conversationState";
    public static final String CONVERSATION_STAGE = "stage";
    public static final String CONVERSATION_CSAT = "csatRate";
    public static final String CONVERSATION_CSAT_YESNO_VALUE = "csatResolutionConfirmation";
    public static final String CONVERSATION_CSAT_STATUS = "status";
    public static final String CONVERSATION_FIELD = "conversationField";
    public static final String PARTICIPANTS_CHANGE_FIELD = "ParticipantsChange";
    public static final String DIALOG_CHANGE_FIELD = "DialogChange";
    public static final String TTR = "ttrType";
    private static final String TTR_VALUE = "value";
    public String conversationId;
    public String dialogId;
    public String field;
    public ConversationState conversationState;
    public DialogState dialogState;
    public TTRType ttrType;
    public int ttrValue;
    public int csatNumberOfStars;
    public int csatYesNoValue;
    public CsatStatus csatStatus;
    public String type;
    private String closingCause;
    private MultiDialog.ChannelType channelType;
    private JSONObject cobrowseMetadata;
    private List<ConversationField> conversationFieldList;

    public static String CONVERSATION_STATE_FIELD() {
        return AmsDialogs.isUmsSupportingDialogs() ? CONVERSATION_STAGE_FIELD : CONVERSATION_STATE_FIELD;
    }

    public UpdateConversationField(String dialogId, String conversationId, JSONObject cobrowseMetadata) {
        this.field = DIALOG_CHANGE_FIELD;
        this.conversationId = conversationId;
        this.dialogId = dialogId;
        this.type = UPDATE;
        this.channelType = MultiDialog.ChannelType.COBROWSE;
        this.cobrowseMetadata = cobrowseMetadata;
        this.dialogState = DialogState.CLOSE;
    }

    public UpdateConversationField(String dialogId, String conversationId, String field, String closingCause, DialogState dialogState) {
        this.type = UPDATE;
        this.closingCause = closingCause;
        this.conversationId = conversationId;
        this.dialogId = dialogId;
        this.field = field;
        this.dialogState = dialogState;
    }

    public UpdateConversationField(String conversationId, String field, ConversationState conversationState) {
        this.conversationId = conversationId;
        this.field = field;
        this.conversationState = conversationState;
    }

    public UpdateConversationField(String convId, String field, int numberOfStars, int csatYesNoValue, CsatStatus status) {
        this.conversationId = convId;
        this.field = field;
        this.csatNumberOfStars = numberOfStars;
        this.csatYesNoValue = csatYesNoValue;
        this.csatStatus = status;
    }

    public UpdateConversationField(String convId, String field, TTRType ttrType, int value) {
        this.conversationId = convId;
        this.field = field;
        this.ttrType = ttrType;
        this.ttrValue = value;
    }

    public UpdateConversationField(String conversationId, String field, ArrayList<ConversationField> conversationFields) {
        this.conversationId = conversationId;
        this.field = field;
        this.conversationFieldList = conversationFields;
    }

    @Override
    public String getMessageType() {
        return UPDATE_CONVERSATION_FIELD_TYPE;
    }

    @Override
    protected void toJson(JSONObject json) throws JSONException {
        this.body.put(CONVERSATION_ID, (Object)this.conversationId);
        JSONObject conversationFieldObject = new JSONObject();
        JSONArray conversationFieldArray = new JSONArray();
        switch (this.field) {
            case "Stage": {
                conversationFieldObject.put(FIELD, (Object)this.field);
                conversationFieldObject.put(CONVERSATION_STAGE, (Object)this.conversationState.name());
                break;
            }
            case "ConversationStateField": {
                conversationFieldObject.put(FIELD, (Object)this.field);
                conversationFieldObject.put(CONVERSATION_STATE, (Object)this.conversationState.name());
                break;
            }
            case "CSATRate": {
                conversationFieldObject.put(FIELD, (Object)this.field);
                if (this.csatYesNoValue > -1) {
                    conversationFieldObject.put(CONVERSATION_CSAT_YESNO_VALUE, this.csatYesNoValue == 1);
                }
                if (this.csatNumberOfStars == -1) {
                    conversationFieldObject.put(CONVERSATION_CSAT, JSONObject.NULL);
                } else {
                    conversationFieldObject.put(CONVERSATION_CSAT, this.csatNumberOfStars);
                }
                conversationFieldObject.put(CONVERSATION_CSAT_STATUS, (Object)this.csatStatus.name());
                break;
            }
            case "TTRField": {
                conversationFieldObject.put(FIELD, (Object)this.field);
                conversationFieldObject.put(TTR, (Object)this.ttrType.name());
                conversationFieldObject.put(TTR_VALUE, this.ttrValue);
                break;
            }
            case "DialogChange": {
                conversationFieldObject.put(FIELD, (Object)this.field);
                JSONObject dialogObject = new JSONObject();
                dialogObject.put(DIALOG_ID, (Object)this.dialogId);
                dialogObject.put(STATE, (Object)this.dialogState.name());
                if (this.dialogState == DialogState.CLOSE) {
                    if (this.channelType == MultiDialog.ChannelType.COBROWSE) {
                        dialogObject.put(DIALOG_TYPE, (Object)DialogType.OTHER.name());
                        dialogObject.put(DIALOG_CHANNEL_TYPE, (Object)this.channelType.name());
                        if (this.cobrowseMetadata != null) {
                            dialogObject.put(COBROWSE_DIALOG_METADATA, (Object)this.cobrowseMetadata);
                        }
                    } else {
                        dialogObject.put(CLOSED_BY, (Object)CloseReason.CONSUMER.name());
                    }
                }
                if (this.channelType == MultiDialog.ChannelType.COBROWSE) {
                    conversationFieldObject.put(DIALOG_ID, (Object)this.dialogId);
                } else {
                    conversationFieldObject.put(CONVERSATION_ID, (Object)this.conversationId);
                }
                conversationFieldObject.put(TYPE, (Object)this.type);
                conversationFieldObject.put(DIALOG, (Object)dialogObject);
                break;
            }
            case "ParticipantsChange": {
                for (ConversationField field : this.conversationFieldList) {
                    JSONObject fieldObject = new JSONObject();
                    fieldObject.put(FIELD, (Object)PARTICIPANTS_CHANGE_FIELD);
                    fieldObject.put(TYPE, (Object)field.getType());
                    fieldObject.put(USER_ID, (Object)field.getUserId());
                    fieldObject.put(ROLE, (Object)field.getRole());
                    conversationFieldArray.put((Object)fieldObject);
                }
                break;
            }
        }
        if (this.field.equals(PARTICIPANTS_CHANGE_FIELD)) {
            this.body.put(CONVERSATION_FIELD, (Object)conversationFieldArray);
        } else {
            this.body.put(CONVERSATION_FIELD, (Object)conversationFieldObject);
        }
        json.put("body", (Object)this.body);
    }
}

