/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.liveperson.api.response.model.ContentType;
import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.infra.CommandCallback;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.infra.utils.LinkUtils;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.infra.utils.UniqueID;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.BaseSendMessageCommand;
import com.liveperson.messaging.commands.ResolveConversationCommand;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.network.MessageTimeoutQueue;
import com.liveperson.messaging.network.socket.requests.NewConversationRequest;
import com.liveperson.messaging.network.socket.requests.SendMessageRequest;
import com.liveperson.messaging.offline.OfflineMessagingManager;
import com.liveperson.messaging.offline.api.OfflineMessagesRepository;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SendMessageCommand
extends BaseSendMessageCommand {
    private static final String TAG = "SendMessageCommand";
    protected final Messaging mController;
    protected String mBrandId;
    protected String mTargetId;
    protected MaskedMessage mMessage;
    protected String mConsumerId;
    protected String mEventId;
    protected DeliveryStatusUpdateInfo mInfo;

    public SendMessageCommand(Messaging controller, String targetId, String brandId, MaskedMessage message) {
        this.mController = controller;
        this.mBrandId = brandId;
        this.mTargetId = targetId;
        this.mMessage = message;
    }

    public SendMessageCommand(Messaging controller, String targetId, String brandId, MaskedMessage message, @Nullable DeliveryStatusUpdateInfo info) {
        this(controller, targetId, brandId, message);
        this.mInfo = info;
    }

    public void execute() {
        LPLog.INSTANCE.d(TAG, "execute");
        Dialog activeDialog = this.mController.amsDialogs.getActiveDialog();
        Conversation conversation = this.mController.amsConversations.getConversationFromTargetIdMap(this.mTargetId);
        this.mConsumerId = this.mController.amsUsers.getConsumerId(this.mTargetId);
        OfflineMessagingManager manager = this.mController.getOfflineManager();
        OfflineMessagesRepository offlineMessagesRepository = this.mController.amsMessages.getOfflineMessagesRepository();
        if (manager.isOfflineModeEnabled() && this.canSendWhileOffline() && !manager.isFullySynced()) {
            DataBaseCommand<Dialog> command = manager.getOrCreateOfflineDialog();
            command.setPostQueryOnBackground(offlineDialog -> {
                String dialogId;
                if (offlineDialog == null) {
                    dialogId = "OFFLINE_DIALOG";
                } else {
                    dialogId = offlineDialog.getDialogId();
                    if (offlineDialog.getLastServerSequence() == -1) {
                        LPLog.INSTANCE.d(TAG, "Adding metadata for offline message.");
                        this.formMetadataOnNewConversation(this.mBrandId);
                        offlineDialog.setLastServerSequence(offlineDialog.getLastServerSequence() + 1);
                    }
                }
                this.addMessageToDB(dialogId, this.mMessage, MessagingChatMessage.MessageState.OFFLINE);
            });
            command.execute();
        } else if (conversation == null || conversation.getState() == ConversationState.CLOSE || conversation.getState() == ConversationState.LOCKED) {
            if (manager.isOfflineModeEnabled() && offlineMessagesRepository.areOfflineMessagesExists(this.mBrandId)) {
                this.addMessageToDB("OFFLINE_DIALOG", this.mMessage, MessagingChatMessage.MessageState.OFFLINE);
            } else {
                this.formMetadataOnNewConversation(this.mBrandId);
                this.sendOnNewConversation();
            }
        } else if (activeDialog == null) {
            LPLog.INSTANCE.w(TAG, "'Zombie Conversation' state occurred (One conversation is open without open dialogs) while the consumer is trying to send a message! Closing this conversation and open a new one....");
            ResolveConversationCommand resolveConversationCommand = new ResolveConversationCommand(this.mController.amsConversations, this.mTargetId, this.mController.mAccountsController.getConnectionUrl(this.mBrandId));
            resolveConversationCommand.setCallback(new ICallback<String, Throwable>(){

                public void onSuccess(String value) {
                    SendMessageCommand.this.sendOnNewConversation();
                }

                public void onError(Throwable error) {
                    LPLog.INSTANCE.e(SendMessageCommand.TAG, ErrorCode.ERR_000000A7, "Failed to resolve conversation before creating a new one, continuing with creating anyway", error);
                    SendMessageCommand.this.sendOnNewConversation();
                }
            });
            resolveConversationCommand.execute();
        } else {
            LPLog.INSTANCE.d(TAG, "Send message - activeDialog = " + activeDialog.getDialogId() + ", " + (Object)((Object)activeDialog.getState()));
            switch (activeDialog.getState()) {
                case CLOSE: {
                    this.sendOnNewConversation();
                    break;
                }
                case LOCKED: {
                    break;
                }
                case OPEN: 
                case PENDING: 
                case QUEUED: {
                    if (manager.isOfflineModeEnabled() && offlineMessagesRepository.areOfflineMessagesExists(this.mBrandId)) {
                        this.addMessageToDB("OFFLINE_DIALOG", this.mMessage, MessagingChatMessage.MessageState.OFFLINE);
                        break;
                    }
                    this.addMessageToDBAndSend(activeDialog.getDialogId(), this.mMessage, MessagingChatMessage.MessageState.PENDING);
                }
            }
        }
    }

    protected void formMetadataOnNewConversation(String brandId) {
        try {
            String strMetadata = this.mController.getWelcomeMessageMetadata(brandId);
            if (strMetadata != null && !strMetadata.isEmpty()) {
                LPLog.INSTANCE.d(TAG, "formMetadataOnNewConversation");
                JSONObject wmMetadata = new JSONObject(strMetadata);
                if (this.mInfo != null && this.mInfo.getMetadata() != null) {
                    this.mInfo.getMetadata().put((Object)wmMetadata);
                } else {
                    this.mInfo = new DeliveryStatusUpdateInfo(new JSONArray().put((Object)wmMetadata));
                }
                this.mController.setWelcomeMessageMetadata(null, brandId);
            }
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000016B, "Failed to form metadata of welcome message", (Throwable)e);
        }
    }

    private void sendOnNewConversation() {
        NewConversationRequest newConversationRequest = this.createPendingConversationAndDialog();
        this.sendCreateConversationRequest(newConversationRequest);
        this.addMessageToDBAndSend("TEMP_DIALOG", this.mMessage, MessagingChatMessage.MessageState.PENDING);
        LPLog.INSTANCE.d(TAG, "sendOnNewConversation: " + LPLog.INSTANCE.mask((Object)this.mMessage));
    }

    protected NewConversationRequest createPendingConversationAndDialog() {
        NewConversationRequest newConversationRequest = this.createNewConversationRequest();
        this.mController.amsConversations.createPendingConversation(this.mTargetId, this.mBrandId, newConversationRequest.getRequestId());
        this.mController.amsDialogs.createPendingDialog(this.mTargetId, this.mBrandId, newConversationRequest.getRequestId());
        return newConversationRequest;
    }

    private NewConversationRequest createNewConversationRequest() {
        return this.createNewConversationRequest("TEMP_CONVERSATION", "TEMP_DIALOG", null);
    }

    protected NewConversationRequest createNewConversationRequest(String tempConversationId, String tempDialogId, Long requestId) {
        NewConversationRequest newConversationRequest = new NewConversationRequest(this.mController, this.mTargetId, this.mBrandId, tempConversationId, tempDialogId);
        if (requestId != null) {
            newConversationRequest.setRequestId(requestId);
        }
        this.mController.amsConversations.enqueuePendingConversationRequestId(newConversationRequest.getRequestId());
        return newConversationRequest;
    }

    public void sendCreateConversationRequest(NewConversationRequest newConversationRequest) {
        SocketManager.getInstance().send((BaseSocketRequest)newConversationRequest);
    }

    protected void sendMessage(String conversationId, String dialogId, String message) {
        SendMessageRequest sendMessageRequest = new SendMessageRequest(this.mController, this.mEventId, this.mTargetId, this.mBrandId, conversationId, dialogId, message);
        this.sendMessage(dialogId, sendMessageRequest);
    }

    protected void sendMessage(String dialogId, SendMessageRequest sendMessageRequest) {
        SocketManager.getInstance().send((BaseSocketRequest)sendMessageRequest);
        this.mController.amsMessages.mMessageTimeoutQueue.add(MessageTimeoutQueue.MessageType.PUBLISH, (int)sendMessageRequest.getRequestId(), this.mBrandId, dialogId, this.mEventId);
    }

    protected void sendMessageIfDialogIsOpen() {
        Dialog dialog = this.mController.amsDialogs.getActiveDialog();
        if (dialog != null) {
            LPLog.INSTANCE.d(TAG, "sendMessageIfDialogIsOpen: " + (Object)((Object)dialog.getState()));
            if (dialog.getState() == DialogState.OPEN) {
                SendMessageRequest sendMessageRequest = this.createMessageRequest(this.mController, this.mEventId, this.mTargetId, this.mBrandId, dialog.getDialogId(), dialog.getConversationId());
                this.sendMessage(dialog.getDialogId(), sendMessageRequest);
            } else if (dialog.getState() == DialogState.PENDING || dialog.getState() == DialogState.QUEUED) {
                SendMessageRequest sendMessageRequest = this.createMessageRequest(this.mController, this.mEventId, this.mTargetId, this.mBrandId, dialog.getDialogId(), dialog.getConversationId());
                dialog.getPendingData().addToPendingRequests(sendMessageRequest);
            } else {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000A8, "sendMessageIfDialogIsOpen: unhandled dialog state:" + (Object)((Object)dialog.getState()));
            }
        } else {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000A9, "sendMessageIfDialogIsOpen: Failed to find an active dialog!");
        }
    }

    protected void addMessageToDB(String dialogId, MaskedMessage message, MessagingChatMessage.MessageState state) {
        this.mEventId = UniqueID.createUniqueMessageEventId();
        LPLog.INSTANCE.i(TAG, "addMessageToDB without sending: mEventId = " + this.mEventId + " dialog ID = " + dialogId);
        MessagingChatMessage chatMessage = this.createNewChatMessage(dialogId, message, state);
        if (this.mInfo != null && this.mInfo.getMetadata() != null) {
            chatMessage.setMetadata(this.mInfo.getMetadata().toString());
        }
        this.mController.amsMessages.addMessage(chatMessage, true).setPostQueryOnBackground(data -> {
            CommandCallback commandCallback = this.getCallback();
            if (commandCallback != null) {
                commandCallback.onSuccess();
            }
        }).execute();
        if (this.mMessage.isMasked()) {
            String maskedEventId = this.mEventId + "-mm";
            MessagingChatMessage warning = new MessagingChatMessage(chatMessage.getOriginatorId(), message.getMaskedSystemMessage(), chatMessage.getTimeStamp() + 1L, chatMessage.getDialogId(), maskedEventId, MessagingChatMessage.MessageType.SYSTEM_MASKED, MessagingChatMessage.MessageState.RECEIVED, -3, ContentType.text_plain.getText(), EncryptionVersion.NONE);
            this.mController.amsMessages.addMessage(warning, true).execute();
        }
    }

    protected void addMessageToDBAndSend(String dialogId, MaskedMessage message, MessagingChatMessage.MessageState messageState) {
        this.mEventId = UniqueID.createUniqueMessageEventId();
        LPLog.INSTANCE.i(TAG, "addMessageToDBAndSend: mEventId = " + this.mEventId + " dialog ID = " + dialogId);
        MessagingChatMessage chatMessage = this.createNewChatMessage(dialogId, message, messageState);
        if (this.mInfo != null && this.mInfo.getMetadata() != null) {
            chatMessage.setMetadata(this.mInfo.getMetadata().toString());
        }
        this.mController.amsMessages.addMessage(chatMessage, true).setPreQueryOnBackground(() -> this.attachMessageToOfflineModeIfNeeded(chatMessage)).setPostQueryOnBackground(data -> {
            CommandCallback commandCallback = this.getCallback();
            if (commandCallback != null) {
                commandCallback.onSuccess();
            }
            LPLog.INSTANCE.i(TAG, "Send message, time: " + chatMessage.getTimeStamp());
            if (chatMessage.getMessageState() != MessagingChatMessage.MessageState.OFFLINE) {
                this.sendMessageIfDialogIsOpen();
            }
        }).execute();
        if (this.mMessage.isMasked()) {
            MessagingChatMessage warning = new MessagingChatMessage(chatMessage.getOriginatorId(), message.getMaskedSystemMessage(), chatMessage.getTimeStamp() + 1L, chatMessage.getDialogId(), this.mEventId + "-mm", MessagingChatMessage.MessageType.SYSTEM_MASKED, MessagingChatMessage.MessageState.RECEIVED, -3, ContentType.text_plain.getText(), EncryptionVersion.NONE);
            this.mController.amsMessages.addMessage(warning, true).execute();
        }
    }

    @NonNull
    protected MessagingChatMessage createNewChatMessage(String dialogId, MaskedMessage message, MessagingChatMessage.MessageState state) {
        MessagingChatMessage.MessageType messageType = message.isMasked() ? (LinkUtils.containsWebUrls((String)message.getDbMessage()) ? MessagingChatMessage.MessageType.CONSUMER_URL_MASKED : MessagingChatMessage.MessageType.CONSUMER_MASKED) : (LinkUtils.containsWebUrls((String)message.getDbMessage()) ? MessagingChatMessage.MessageType.CONSUMER_URL : MessagingChatMessage.MessageType.CONSUMER);
        return new MessagingChatMessage(this.mConsumerId, message.getDbMessage(), System.currentTimeMillis(), dialogId, this.mEventId, messageType, state, EncryptionVersion.NONE);
    }

    protected void attachMessageToOfflineModeIfNeeded(MessagingChatMessage chatMessage) {
        MessagingChatMessage.MessageState state = chatMessage.getMessageState();
        OfflineMessagingManager offlineManager = this.mController.getOfflineManager();
        if (offlineManager != null && offlineManager.isOfflineModeEnabled() && (state.equals((Object)MessagingChatMessage.MessageState.PENDING) || state.equals((Object)MessagingChatMessage.MessageState.QUEUED))) {
            OfflineMessagesRepository repository = this.mController.amsMessages.getOfflineMessagesRepository();
            Set<String> pendingOfflineMessages = repository.getPendingOfflineMessages(this.mBrandId);
            pendingOfflineMessages.add(chatMessage.getEventId());
            repository.setPendingOfflineMessages(this.mBrandId, pendingOfflineMessages);
        }
    }

    @NonNull
    protected SendMessageRequest createMessageRequest(Messaging mController, String mEventId, String mTargetId, String mBrandId, String dialogId, String conversationId) {
        SendMessageRequest sendMessageRequest = new SendMessageRequest(mController, mEventId, mTargetId, mBrandId, dialogId, conversationId);
        sendMessageRequest.setMessageContent(this.mMessage.getServerMessage());
        sendMessageRequest.setInfo(this.mInfo);
        return sendMessageRequest;
    }

    public String getEventId() {
        return this.mEventId;
    }

    protected boolean canSendWhileOffline() {
        return true;
    }
}

