/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.pusher;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpDeleteRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.infra.otel.LPTraceType;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.pusher.PusherHelper;
import com.liveperson.messaging.model.SynchronizedInternetConnectionCallback;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\u000bj\u0002`\f0\t\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u00020\u00172\n\u0010\u0019\u001a\u00060\u000bj\u0002`\fH\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\b\u0010\u001b\u001a\u00020\u0017H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\u000bj\u0002`\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/liveperson/messaging/commands/pusher/DeletePendingProactiveMessagesCommand;", "Lcom/liveperson/infra/Command;", "controller", "Lcom/liveperson/messaging/Messaging;", "brandId", "", "transactionIds", "", "callback", "Lcom/liveperson/infra/ICallback;", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Lcom/liveperson/messaging/Messaging;Ljava/lang/String;Ljava/util/Set;Lcom/liveperson/infra/ICallback;)V", "getBrandId", "()Ljava/lang/String;", "getCallback", "()Lcom/liveperson/infra/ICallback;", "getController", "()Lcom/liveperson/messaging/Messaging;", "mPusherHelper", "Lcom/liveperson/messaging/commands/pusher/PusherHelper;", "execute", "", "notifyError", "exception", "sendRequest", "validateStateAndSendRequest", "Companion", "messaging_release"})
public final class DeletePendingProactiveMessagesCommand
implements Command {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Messaging controller;
    @NotNull
    private final String brandId;
    @NotNull
    private final Set<String> transactionIds;
    @NotNull
    private final ICallback<Boolean, Exception> callback;
    @Nullable
    private PusherHelper mPusherHelper;
    @NotNull
    private static final String TAG = "DeletePendingProactiveMessagesCommand";
    private static final int REQUEST_TIMEOUT = 30000;
    @NotNull
    private static final String ERROR_UNABLE_TO_MAKE_REQUEST = "Unable to DeletePendingProactiveMessagesCommand.";
    @NotNull
    private static final String DELETE_URL = "https://%1$s/api/account/%2$s/proactive/pending-messages?appId=%3$s&consumerId=%4$s&transactionIds=%5$s&v=1";

    public DeletePendingProactiveMessagesCommand(@NotNull Messaging controller, @NotNull String brandId, @NotNull Set<String> transactionIds, @NotNull ICallback<Boolean, Exception> callback) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter(transactionIds, (String)"transactionIds");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.controller = controller;
        this.brandId = brandId;
        this.transactionIds = transactionIds;
        this.callback = callback;
    }

    @NotNull
    public final Messaging getController() {
        return this.controller;
    }

    @NotNull
    public final String getBrandId() {
        return this.brandId;
    }

    @NotNull
    public final ICallback<Boolean, Exception> getCallback() {
        return this.callback;
    }

    public void execute() {
        this.mPusherHelper = new PusherHelper(this.brandId, this.controller);
        Collection collection = this.transactionIds;
        if (collection == null || collection.isEmpty()) {
            this.notifyError(new Exception("Unable to DeletePendingProactiveMessagesCommand.} Error: No transactionId"));
            return;
        }
        this.validateStateAndSendRequest();
    }

    private final void validateStateAndSendRequest() {
        if (InternetConnectionService.isNetworkAvailable()) {
            this.sendRequest();
        } else {
            new SynchronizedInternetConnectionCallback(() -> DeletePendingProactiveMessagesCommand.validateStateAndSendRequest$lambda-0(this)).execute();
        }
    }

    private final void sendRequest() {
        if (this.mPusherHelper == null) {
            this.mPusherHelper = new PusherHelper(this.brandId, this.controller);
        }
        PusherHelper pusherHelper = this.mPusherHelper;
        String pusherDomain = pusherHelper != null ? pusherHelper.getPusherDomain() : null;
        CharSequence charSequence = pusherDomain;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            this.notifyError(new Exception("Unable to DeletePendingProactiveMessagesCommand.} Error: Missing Domain"));
            return;
        }
        PusherHelper pusherHelper2 = this.mPusherHelper;
        String consumerId = pusherHelper2 != null ? pusherHelper2.getConsumerId() : null;
        CharSequence charSequence2 = consumerId;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            this.notifyError(new Exception("Unable to DeletePendingProactiveMessagesCommand.} Error: Missing consumerID"));
            return;
        }
        PusherHelper pusherHelper3 = this.mPusherHelper;
        String token = pusherHelper3 != null ? pusherHelper3.getAuthToken() : null;
        CharSequence charSequence3 = token;
        if (charSequence3 == null || StringsKt.isBlank((CharSequence)charSequence3)) {
            this.notifyError(new Exception("Unable to DeletePendingProactiveMessagesCommand.} Error: Missing auth token"));
            return;
        }
        PusherHelper pusherHelper4 = this.mPusherHelper;
        String appId = pusherHelper4 != null ? pusherHelper4.getAppId() : null;
        CharSequence charSequence4 = appId;
        if (charSequence4 == null || StringsKt.isBlank((CharSequence)charSequence4)) {
            this.notifyError(new Exception("Unable to DeletePendingProactiveMessagesCommand. Error: Missing appID"));
            return;
        }
        String sTransactionIds = CollectionsKt.joinToString$default((Iterable)this.transactionIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        String string2 = DELETE_URL;
        Object[] objectArray = new Object[]{pusherDomain, this.brandId, appId, consumerId, sTransactionIds};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        String requestURL = string3;
        PusherHelper pusherHelper5 = this.mPusherHelper;
        List<String> certificates = pusherHelper5 != null ? pusherHelper5.getCertificatePinningKeys() : null;
        HttpDeleteRequest httpDeleteRequest = new HttpDeleteRequest(requestURL, LPTraceType.PUSHER_DELETE_PENDING_PROACTIVE_MESSAGES_REQ);
        httpDeleteRequest.addHeader("Authorization", "Bearer " + token);
        httpDeleteRequest.setTimeout(30000);
        httpDeleteRequest.setCertificatePinningKeys(certificates);
        httpDeleteRequest.setCallback((ICallback)new ICallback<String, Exception>(this){
            final /* synthetic */ DeletePendingProactiveMessagesCommand this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@Nullable String value) {
                this.this$0.getCallback().onSuccess((Object)true);
            }

            public void onError(@NotNull Exception exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                DeletePendingProactiveMessagesCommand.access$notifyError(this.this$0, exception);
            }
        });
        HttpHandler.execute((HttpRequest)((HttpRequest)httpDeleteRequest));
    }

    private final void notifyError(Exception exception) {
        String string2 = exception.getMessage();
        if (string2 == null) {
            string2 = "unknown";
        }
        LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000016J, string2);
        Infra.instance.postOnMainThread(() -> DeletePendingProactiveMessagesCommand.notifyError$lambda-1(exception, this));
    }

    private static final void validateStateAndSendRequest$lambda-0(DeletePendingProactiveMessagesCommand this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.sendRequest();
    }

    private static final void notifyError$lambda-1(Exception $exception, DeletePendingProactiveMessagesCommand this$0) {
        Intrinsics.checkNotNullParameter((Object)$exception, (String)"$exception");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($exception instanceof SSLPeerUnverifiedException) {
            this$0.controller.mEventsProxy.onError(LpError.INVALID_CERTIFICATE, $exception.getMessage());
        }
        this$0.callback.onError((Throwable)$exception);
    }

    public static final /* synthetic */ void access$notifyError(DeletePendingProactiveMessagesCommand $this, Exception exception) {
        $this.notifyError(exception);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/liveperson/messaging/commands/pusher/DeletePendingProactiveMessagesCommand$Companion;", "", "()V", "DELETE_URL", "", "ERROR_UNABLE_TO_MAKE_REQUEST", "REQUEST_TIMEOUT", "", "TAG", "messaging_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

