/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.pusher;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.PushType;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.http.requests.PushRequest;
import com.liveperson.infra.preferences.PushMessagePreferences;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.pusher.PusherHelper;
import com.liveperson.messaging.model.SynchronizedAuthenticationCompletedCallback;
import java.util.List;

public class RegisterPusherCommand
implements Command {
    private static final String TAG = "RegisterPusherCommand";
    private static final String PUSHER_URL = "https://%s/api/account/%s/device/register";
    private final Messaging mController;
    private final LPAuthenticationParams mLpAuthParams;
    private String mBrandId;
    private String deviceToken;
    private String platform;
    private String mAppId;
    @Nullable
    private ICallback<Void, Exception> mRegistrationCompletedCallback;
    private PusherHelper pusherHelper;

    public RegisterPusherCommand(Messaging messagingController, String brandId, String appId, String token, PushType pushType, LPAuthenticationParams lpAuthParams, @Nullable ICallback<Void, Exception> registrationCompletedCallback) {
        this.mController = messagingController;
        this.mBrandId = brandId;
        this.deviceToken = token;
        this.platform = pushType.getPlatform();
        this.mAppId = appId;
        this.mLpAuthParams = lpAuthParams;
        this.mRegistrationCompletedCallback = registrationCompletedCallback;
    }

    public void execute() {
        boolean isExecuting2;
        this.pusherHelper = new PusherHelper(this.mBrandId, this.mController);
        LPLog.INSTANCE.i(TAG, "execute with token " + LPLog.INSTANCE.mask((Object)this.deviceToken));
        if (TextUtils.isEmpty((CharSequence)this.mAppId)) {
            this.mAppId = PreferenceManager.getInstance().getStringValue("APP_ID_PREFERENCE_KEY", this.mBrandId, "");
        } else {
            PreferenceManager.getInstance().setStringValue("APP_ID_PREFERENCE_KEY", this.mBrandId, this.mAppId);
        }
        if (TextUtils.isEmpty((CharSequence)this.deviceToken)) {
            this.deviceToken = PreferenceManager.getInstance().getStringValue("PUSHER_DEVICE_TOKEN_PREFERENCE_KEY", this.mBrandId, "");
            if (TextUtils.isEmpty((CharSequence)this.deviceToken)) {
                LPLog.INSTANCE.w(TAG, "device token is empty. skip register pusher.");
                this.reportError(new IllegalStateException("Failed to register pusher. Missing device token."));
                return;
            }
        } else {
            PreferenceManager.getInstance().setStringValue("PUSHER_DEVICE_TOKEN_PREFERENCE_KEY", this.mBrandId, this.deviceToken);
        }
        if (!(isExecuting2 = new SynchronizedAuthenticationCompletedCallback(this.mController.mAccountsController, this.mBrandId, new ICallback<Void, Exception>(){

            public void onSuccess(Void value) {
                List<String> certificates = RegisterPusherCommand.this.pusherHelper.getCertificatePinningKeys();
                String pusherDomain = RegisterPusherCommand.this.pusherHelper.getPusherDomain();
                if (TextUtils.isEmpty((CharSequence)pusherDomain)) {
                    LPLog.INSTANCE.e(RegisterPusherCommand.TAG, ErrorCode.ERR_0000014C, "pusherDomain does not exists. Failed to register push");
                    RegisterPusherCommand.this.reportError(new Exception("Pusher domain is empty!, SDK may not initialized!"));
                    return;
                }
                String pusherURL = String.format(RegisterPusherCommand.PUSHER_URL, pusherDomain, RegisterPusherCommand.this.mBrandId);
                String consumerId = RegisterPusherCommand.this.pusherHelper.getConsumerId();
                if (TextUtils.isEmpty((CharSequence)consumerId)) {
                    LPLog.INSTANCE.w(RegisterPusherCommand.TAG, "fetchConsumerIdAndSendRequest: Cannot get consumerId. Quit register pusher");
                    RegisterPusherCommand.this.reportError(new Exception("Failed to register pusher. Error: Missing consumerID"));
                    return;
                }
                this.sendRequest(pusherURL, consumerId, certificates);
            }

            public void onError(Exception exception) {
                RegisterPusherCommand.this.reportError(exception);
            }

            private void sendRequest(String pusherURL, String consumerId, List<String> certificates) {
                LPLog.INSTANCE.i(RegisterPusherCommand.TAG, "Running register pusher with token " + LPLog.INSTANCE.mask((Object)RegisterPusherCommand.this.deviceToken));
                String token = RegisterPusherCommand.this.pusherHelper.getAuthToken();
                String authType = RegisterPusherCommand.this.pusherHelper.getAuthType();
                PushMessagePreferences.INSTANCE.setPushPlatform(RegisterPusherCommand.this.platform);
                new PushRequest(pusherURL, consumerId, RegisterPusherCommand.this.mAppId, RegisterPusherCommand.this.deviceToken, token, RegisterPusherCommand.this.platform, authType, certificates, true).setCallback((ICallback)new ICallback<Void, Exception>(){

                    public void onSuccess(Void value) {
                        PreferenceManager.getInstance().setBooleanValue("IS_PUSHER_REGISTERED_PREFERENCE_KEY", RegisterPusherCommand.this.mBrandId, true);
                        PreferenceManager.getInstance().remove("CONSUMER_UNREGISTER_PUSHER_PREFERENCE_KEY", RegisterPusherCommand.this.mBrandId);
                        if (RegisterPusherCommand.this.mRegistrationCompletedCallback != null) {
                            RegisterPusherCommand.this.mRegistrationCompletedCallback.onSuccess((Object)value);
                        }
                    }

                    public void onError(Exception exception) {
                        if (RegisterPusherCommand.this.mRegistrationCompletedCallback != null) {
                            RegisterPusherCommand.this.mRegistrationCompletedCallback.onError((Throwable)exception);
                        }
                    }
                }).execute();
            }
        }).executeWithReturnValue()) && this.mLpAuthParams != null) {
            this.mController.connect(this.mBrandId, this.mLpAuthParams, null, true);
        }
    }

    private void reportError(Exception error) {
        if (this.mRegistrationCompletedCallback != null) {
            this.mRegistrationCompletedCallback.onError((Throwable)error);
        }
    }
}

