/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.controller;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.Infra;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.utils.DeviceUtils;
import com.liveperson.infra.utils.VersionUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientProperties
implements Clearable {
    private static final String TAG = "ClientProperties";
    private static final String APP_ID_PREFERENCE_KEY = "APP_ID_PREFERENCE_KEY";
    private static final String APP_ID = "appId";
    private static final String DEVICE_FAMILY = "deviceFamily";
    private static final String OS = "os";
    private static final String IP_ADDRESS = "ipAddress";
    private static final String OS_NAME = "osName";
    private static final String OS_VERSION = "osVersion";
    private static final String INTEGRATION = "integration";
    private static final String INTEGRATION_VERSION = "integrationVersion";
    private static final String TIME_ZONE = "timeZone";
    private static final String DEVICE_MANUFACTURER = "deviceManufacture";
    private static final String DEVICE_MODEL = "deviceModel";
    private static final String APP_VERSION = "appVersion";
    private static final String FEATURES = "features";
    private static final String TYPE = "type";
    private static final String TYPE_VALUE = ".ClientProperties";
    private String mAppId;
    private String mSdkVersion;
    private final String ipAddress;
    private JSONObject mJson;

    public ClientProperties(String appId, String appVersion) {
        String _ipAddress = "unknown";
        try {
            _ipAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000008E, "Failed to get ip address, unknown host exception.", (Throwable)e);
        }
        this.ipAddress = _ipAddress;
        this.saveAppId(appId);
        this.saveSDKVersion(appVersion);
        this.createJson();
        LPLog.INSTANCE.v(TAG, ClientProperties.getLoggablePropertyDump(Infra.instance.getApplicationContext(), "Created ClientProperties:", appId));
    }

    public ClientProperties() {
        this(null, null);
    }

    private void createJson() {
        this.mJson = new JSONObject();
        try {
            this.mJson.put(APP_ID, (Object)this.mAppId);
            this.mJson.put(APP_VERSION, (Object)VersionUtils.getAppVersion((Context)Infra.instance.getApplicationContext()));
            this.mJson.put(DEVICE_FAMILY, (Object)DeviceFamily.MOBILE.name());
            this.mJson.put(OS, (Object)OperatingSystem.ANDROID.name());
            this.mJson.put(OS_NAME, DeviceUtils.INSTANCE.getOsName());
            this.mJson.put(OS_VERSION, (Object)String.valueOf(Build.VERSION.SDK_INT));
            this.mJson.put(DEVICE_MODEL, (Object)Build.MODEL);
            this.mJson.put(DEVICE_MANUFACTURER, (Object)Build.MANUFACTURER);
            this.mJson.put(INTEGRATION, (Object)Integration.MOBILE_SDK.name());
            this.mJson.put(INTEGRATION_VERSION, (Object)this.mSdkVersion);
            this.mJson.put(TYPE, (Object)TYPE_VALUE);
            JSONArray featuresArray = new JSONArray();
            featuresArray.put((Object)Features.PHOTO_SHARING.name()).put((Object)Features.CO_APP.name()).put((Object)Features.RICH_CONTENT.name()).put((Object)Features.SECURE_FORMS.name()).put((Object)Features.AUTO_MESSAGES.name()).put((Object)Features.QUICK_REPLIES.name()).put((Object)Features.MULTI_DIALOG.name());
            if (Configuration.getBoolean((int)R.bool.enable_file_sharing)) {
                featuresArray.put((Object)Features.FILE_SHARING.name());
            }
            if (Configuration.getBoolean((int)R.bool.enable_markdown_hyperlink)) {
                featuresArray.put((Object)Features.MARKDOWN_HYPERLINKS.name());
            }
            this.mJson.put(FEATURES, (Object)featuresArray);
            this.mJson.put(TIME_ZONE, (Object)TimeZone.getDefault().getID());
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000008F, "JSONException while adding properties to JSON Object.", (Throwable)e);
        }
    }

    public String getJsonString() {
        if (Configuration.getBoolean((int)R.bool.lp_enable_voice_video_call)) {
            try {
                if (!this.hasCobrowse(this.mJson.getJSONArray(FEATURES))) {
                    this.mJson.getJSONArray(FEATURES).put((Object)Features.CO_BROWSE.name());
                }
            }
            catch (JSONException e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000008F, "JSONException while adding properties to JSON Object.", (Throwable)e);
            }
        }
        return this.mJson.toString();
    }

    private boolean hasCobrowse(JSONArray jsonArray) throws JSONException {
        for (int i = 0; i < jsonArray.length(); ++i) {
            if (!jsonArray.getString(i).equals(Features.CO_BROWSE.name())) continue;
            return true;
        }
        return false;
    }

    private void saveAppId(String newAppId) {
        if (TextUtils.isEmpty((CharSequence)newAppId)) {
            this.mAppId = PreferenceManager.getInstance().getStringValue(APP_ID_PREFERENCE_KEY, "appLevelPreferences", "");
        } else {
            this.mAppId = newAppId;
            PreferenceManager.getInstance().setStringValue(APP_ID_PREFERENCE_KEY, "appLevelPreferences", this.mAppId);
        }
    }

    private void saveSDKVersion(String newSdkVersion) {
        if (TextUtils.isEmpty((CharSequence)newSdkVersion)) {
            this.mSdkVersion = PreferenceManager.getInstance().getStringValue("SDK_VERSION_PREFERENCE_KEY", "appLevelPreferences", "");
        } else {
            String oldSdkVersion = PreferenceManager.getInstance().getStringValue("SDK_VERSION_PREFERENCE_KEY", "appLevelPreferences", "");
            if (!TextUtils.isEmpty((CharSequence)oldSdkVersion) && !oldSdkVersion.equals(newSdkVersion)) {
                PreferenceManager.getInstance().setBooleanValue("SDK_VERSION_CHANGED_CLEAR_DATABASE_KEY", "appLevelPreferences", true);
            }
            this.mSdkVersion = newSdkVersion;
            PreferenceManager.getInstance().setStringValue("SDK_VERSION_PREFERENCE_KEY", "appLevelPreferences", this.mSdkVersion);
        }
    }

    public void clear() {
        PreferenceManager.getInstance().remove(APP_ID_PREFERENCE_KEY, "appLevelPreferences");
        PreferenceManager.getInstance().remove("SDK_VERSION_PREFERENCE_KEY", "appLevelPreferences");
        PreferenceManager.getInstance().remove("SDK_VERSION_CHANGED_CLEAR_DATABASE_KEY", "appLevelPreferences");
    }

    @NonNull
    public static String getLoggablePropertyDump(@NonNull Context applicationContext, @NonNull String dumpTitle, @Nullable String appId) {
        return "\n========================================\n" + dumpTitle + "\n----------------------------------------\nDevice Family:      " + DeviceFamily.MOBILE.name() + "\nOS:                 " + OperatingSystem.ANDROID.name() + "\nOS Name:            " + DeviceUtils.INSTANCE.getOsName() + "\nOS Version:         " + Build.VERSION.RELEASE + "\nOS Codename:        " + Build.VERSION.CODENAME + "\nAPI Version:        " + Build.VERSION.SDK_INT + "\nDevice Model:       " + Build.MODEL + "\nDevice Maker:       " + Build.MANUFACTURER + "\n" + (appId != null ? "Host App ID:        " + appId + "\n" : "") + "Host App Version:   " + VersionUtils.getAppVersion((Context)applicationContext) + "\nLP Client:          " + Integration.MOBILE_SDK.name() + "\nLP Client Version:  " + "5.24.0" + "\n========================================";
    }

    private static enum DeviceFamily {
        MOBILE,
        TABLET,
        PERSONAL_COMPUTER,
        PDA,
        OTHER,
        UNKNOWN;

    }

    private static enum OperatingSystem {
        WINDOWS,
        LINUX,
        OSX,
        ANDROID,
        IOS,
        OTHER;

    }

    private static enum Integration {
        WEB_SDK,
        MOBILE_SDK,
        BRAND_SDK;

    }

    public static enum Features {
        CO_BROWSE,
        CO_APP,
        PHOTO_SHARING,
        SECURE_FORMS,
        RICH_CONTENT,
        AUTO_MESSAGES,
        QUICK_REPLIES,
        MULTI_DIALOG,
        FILE_SHARING,
        MARKDOWN_HYPERLINKS;

    }

    private static enum Browser {
        CHROME,
        FIREFOX,
        IE,
        OPERA,
        SAFARI,
        OTHER;

    }
}

