/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.http;

import android.net.Uri;
import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.infra.otel.LPTraceType;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012 \b\u0002\u0010\u0004\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\f\u0012\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u001e\u0010\u0013\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\f\u0012\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b0\u0005H\u0002J\b\u0010\u0014\u001a\u00020\u0006H\u0002R)\u0010\u0004\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\f\u0012\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/liveperson/messaging/network/http/GetActiveConversationsRequest;", "Lcom/liveperson/infra/Command;", "data", "Lcom/liveperson/messaging/network/http/GetActiveConversationsRequest$GetActiveConversationsRequestData;", "callback", "Lcom/liveperson/infra/ICallback;", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Lcom/liveperson/messaging/network/http/GetActiveConversationsRequest$GetActiveConversationsRequestData;Lcom/liveperson/infra/ICallback;)V", "getCallback", "()Lcom/liveperson/infra/ICallback;", "getData", "()Lcom/liveperson/messaging/network/http/GetActiveConversationsRequest$GetActiveConversationsRequestData;", "addHeaders", "", "httpGetRequest", "Lcom/liveperson/infra/network/http/request/HttpGetRequest;", "execute", "prepareCallback", "prepareRequestUrlWithQueryParameters", "Companion", "GetActiveConversationsRequestData", "messaging_release"})
public class GetActiveConversationsRequest
implements Command {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GetActiveConversationsRequestData data;
    @Nullable
    private final ICallback<String, Exception> callback;
    @NotNull
    private static final String TAG = "GetActiveConversationsRequest";
    private static final int GET_ACTIVE_CONVERSATIONS_REQUEST_TIMEOUT = 30000;
    @NotNull
    private static final String OPEN_CONVERSATION_FILTER_JSON = "{\"stage\":\"OPEN\"}";
    @NotNull
    private static final String DOMAIN_TEMPLATE = "https://%1$s/messaging/v1/consumers/%2$s/conversations";

    @JvmOverloads
    public GetActiveConversationsRequest(@NotNull GetActiveConversationsRequestData data, @Nullable ICallback<String, Exception> callback) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
        this.callback = callback;
    }

    public /* synthetic */ GetActiveConversationsRequest(GetActiveConversationsRequestData getActiveConversationsRequestData, ICallback iCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            iCallback = null;
        }
        this(getActiveConversationsRequestData, (ICallback<String, Exception>)iCallback);
    }

    @NotNull
    public final GetActiveConversationsRequestData getData() {
        return this.data;
    }

    @Nullable
    public final ICallback<String, Exception> getCallback() {
        return this.callback;
    }

    public void execute() {
        String mRequestUrl = this.prepareRequestUrlWithQueryParameters();
        HttpGetRequest httpGetRequest = new HttpGetRequest(mRequestUrl, LPTraceType.UMS_GET_OPEN_CONVERSATIONS);
        httpGetRequest.setTimeout(30000);
        this.addHeaders(httpGetRequest);
        httpGetRequest.setCertificatePinningKeys(this.data.getCertificates());
        httpGetRequest.setCallback(this.prepareCallback());
        HttpHandler.execute((HttpRequest)((HttpRequest)httpGetRequest));
    }

    private final void addHeaders(HttpGetRequest httpGetRequest) {
        httpGetRequest.addHeader("authorization", "Bearer " + this.data.getLpToken());
        httpGetRequest.addHeader("Brand-ID", this.data.getSiteId());
        httpGetRequest.addHeader("Client-source", "SDK_Android_UMS_HTTP");
    }

    private final ICallback<String, Exception> prepareCallback() {
        return (ICallback)new ICallback<String, Exception>(this){
            final /* synthetic */ GetActiveConversationsRequest this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@Nullable String value) {
                block1: {
                    ICallback<String, Exception> iCallback;
                    LPLog.INSTANCE.i("GetActiveConversationsRequest", "onSuccess " + LPLog.INSTANCE.mask((Object)value));
                    if (!TextUtils.isEmpty((CharSequence)value) && (iCallback = this.this$0.getCallback()) != null) {
                        ICallback<String, Exception> it = iCallback;
                        boolean bl = false;
                        it.onSuccess((Object)value);
                        return;
                    }
                    ICallback<String, Exception> iCallback2 = this.this$0.getCallback();
                    if (iCallback2 == null) break block1;
                    iCallback2.onError((Throwable)new Exception("Error: empty response from the server"));
                }
            }

            public void onError(@Nullable Exception exception) {
                block2: {
                    Exception exception2 = exception;
                    if (exception2 != null) {
                        Exception exception3 = exception2;
                        GetActiveConversationsRequest getActiveConversationsRequest = this.this$0;
                        Exception $this$onError_u24lambda_u2d2 = exception3;
                        boolean bl = false;
                        ICallback<String, Exception> iCallback = getActiveConversationsRequest.getCallback();
                        if (iCallback != null) {
                            ICallback<String, Exception> it = iCallback;
                            boolean bl2 = false;
                            it.onError((Throwable)exception);
                            return;
                        }
                    }
                    ICallback<String, Exception> iCallback = this.this$0.getCallback();
                    if (iCallback == null) break block2;
                    iCallback.onError((Throwable)new Exception("Error: request failed"));
                }
            }
        };
    }

    private final String prepareRequestUrlWithQueryParameters() {
        String string2 = DOMAIN_TEMPLATE;
        Object object = new Object[]{this.data.getBaseURL(), this.data.getConsumerId()};
        String string3 = String.format(string2, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        String url = string3;
        Uri.Builder uriBuilder = Uri.parse((String)url).buildUpon();
        String string4 = this.data.getLimit();
        if (string4 != null) {
            Object $this$prepareRequestUrlWithQueryParameters_u24lambda_u2d0 = object = string4;
            boolean bl = false;
            uriBuilder.appendQueryParameter("limit", (String)$this$prepareRequestUrlWithQueryParameters_u24lambda_u2d0);
        }
        String string5 = this.data.getSortBy();
        if (string5 != null) {
            Object $this$prepareRequestUrlWithQueryParameters_u24lambda_u2d1 = object = string5;
            boolean bl = false;
            uriBuilder.appendQueryParameter("sortBy", (String)$this$prepareRequestUrlWithQueryParameters_u24lambda_u2d1);
        }
        String string6 = this.data.getFields();
        if (string6 != null) {
            Object $this$prepareRequestUrlWithQueryParameters_u24lambda_u2d2 = object = string6;
            boolean bl = false;
            uriBuilder.appendQueryParameter("fields", (String)$this$prepareRequestUrlWithQueryParameters_u24lambda_u2d2);
        }
        String string7 = this.data.getFilters();
        if (string7 != null) {
            Object $this$prepareRequestUrlWithQueryParameters_u24lambda_u2d3 = object = string7;
            boolean bl = false;
            uriBuilder.appendQueryParameter("filters", (String)$this$prepareRequestUrlWithQueryParameters_u24lambda_u2d3);
        }
        String string8 = this.data.getOffset();
        if (string8 != null) {
            Object $this$prepareRequestUrlWithQueryParameters_u24lambda_u2d4 = object = string8;
            boolean bl = false;
            uriBuilder.appendQueryParameter("offset", (String)$this$prepareRequestUrlWithQueryParameters_u24lambda_u2d4);
        }
        String string9 = this.data.getSortOrder();
        if (string9 != null) {
            Object $this$prepareRequestUrlWithQueryParameters_u24lambda_u2d5 = object = string9;
            boolean bl = false;
            uriBuilder.appendQueryParameter("sortOrder", (String)$this$prepareRequestUrlWithQueryParameters_u24lambda_u2d5);
        }
        String string10 = uriBuilder.build().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"uriBuilder.build().toString()");
        return string10;
    }

    @JvmOverloads
    public GetActiveConversationsRequest(@NotNull GetActiveConversationsRequestData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this(data, null, 2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/liveperson/messaging/network/http/GetActiveConversationsRequest$Companion;", "", "()V", "DOMAIN_TEMPLATE", "", "GET_ACTIVE_CONVERSATIONS_REQUEST_TIMEOUT", "", "OPEN_CONVERSATION_FILTER_JSON", "TAG", "messaging_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\"\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u007f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000eH\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010+\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010,\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010-\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010.\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u008b\u0001\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000eH\u00c6\u0001J\u0013\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00103\u001a\u000204H\u00d6\u0001J\t\u00105\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u001aR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0011R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0011\"\u0004\b\u001e\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0011R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0011\"\u0004\b!\u0010\u001aR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0011\"\u0004\b#\u0010\u001a\u00a8\u00066"}, d2={"Lcom/liveperson/messaging/network/http/GetActiveConversationsRequest$GetActiveConversationsRequestData;", "", "baseURL", "", "siteId", "lpToken", "consumerId", "limit", "offset", "sortBy", "sortOrder", "filters", "fields", "certificates", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getBaseURL", "()Ljava/lang/String;", "getCertificates", "()Ljava/util/List;", "setCertificates", "(Ljava/util/List;)V", "getConsumerId", "getFields", "getFilters", "setFilters", "(Ljava/lang/String;)V", "getLimit", "getLpToken", "getOffset", "setOffset", "getSiteId", "getSortBy", "setSortBy", "getSortOrder", "setSortOrder", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "messaging_release"})
    public static final class GetActiveConversationsRequestData {
        @NotNull
        private final String baseURL;
        @NotNull
        private final String siteId;
        @NotNull
        private final String lpToken;
        @NotNull
        private final String consumerId;
        @Nullable
        private final String limit;
        @Nullable
        private String offset;
        @Nullable
        private String sortBy;
        @Nullable
        private String sortOrder;
        @Nullable
        private String filters;
        @Nullable
        private final String fields;
        @Nullable
        private List<String> certificates;

        public GetActiveConversationsRequestData(@NotNull String baseURL, @NotNull String siteId, @NotNull String lpToken, @NotNull String consumerId, @Nullable String limit, @Nullable String offset, @Nullable String sortBy, @Nullable String sortOrder, @Nullable String filters, @Nullable String fields, @Nullable List<String> certificates) {
            Intrinsics.checkNotNullParameter((Object)baseURL, (String)"baseURL");
            Intrinsics.checkNotNullParameter((Object)siteId, (String)"siteId");
            Intrinsics.checkNotNullParameter((Object)lpToken, (String)"lpToken");
            Intrinsics.checkNotNullParameter((Object)consumerId, (String)"consumerId");
            this.baseURL = baseURL;
            this.siteId = siteId;
            this.lpToken = lpToken;
            this.consumerId = consumerId;
            this.limit = limit;
            this.offset = offset;
            this.sortBy = sortBy;
            this.sortOrder = sortOrder;
            this.filters = filters;
            this.fields = fields;
            this.certificates = certificates;
        }

        public /* synthetic */ GetActiveConversationsRequestData(String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                string6 = null;
            }
            if ((n & 0x20) != 0) {
                string7 = null;
            }
            if ((n & 0x40) != 0) {
                string8 = null;
            }
            if ((n & 0x80) != 0) {
                string9 = null;
            }
            if ((n & 0x100) != 0) {
                string10 = GetActiveConversationsRequest.OPEN_CONVERSATION_FILTER_JSON;
            }
            if ((n & 0x200) != 0) {
                string11 = "id";
            }
            if ((n & 0x400) != 0) {
                list = null;
            }
            this(string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, list);
        }

        @NotNull
        public final String getBaseURL() {
            return this.baseURL;
        }

        @NotNull
        public final String getSiteId() {
            return this.siteId;
        }

        @NotNull
        public final String getLpToken() {
            return this.lpToken;
        }

        @NotNull
        public final String getConsumerId() {
            return this.consumerId;
        }

        @Nullable
        public final String getLimit() {
            return this.limit;
        }

        @Nullable
        public final String getOffset() {
            return this.offset;
        }

        public final void setOffset(@Nullable String string2) {
            this.offset = string2;
        }

        @Nullable
        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(@Nullable String string2) {
            this.sortBy = string2;
        }

        @Nullable
        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(@Nullable String string2) {
            this.sortOrder = string2;
        }

        @Nullable
        public final String getFilters() {
            return this.filters;
        }

        public final void setFilters(@Nullable String string2) {
            this.filters = string2;
        }

        @Nullable
        public final String getFields() {
            return this.fields;
        }

        @Nullable
        public final List<String> getCertificates() {
            return this.certificates;
        }

        public final void setCertificates(@Nullable List<String> list) {
            this.certificates = list;
        }

        @NotNull
        public final String component1() {
            return this.baseURL;
        }

        @NotNull
        public final String component2() {
            return this.siteId;
        }

        @NotNull
        public final String component3() {
            return this.lpToken;
        }

        @NotNull
        public final String component4() {
            return this.consumerId;
        }

        @Nullable
        public final String component5() {
            return this.limit;
        }

        @Nullable
        public final String component6() {
            return this.offset;
        }

        @Nullable
        public final String component7() {
            return this.sortBy;
        }

        @Nullable
        public final String component8() {
            return this.sortOrder;
        }

        @Nullable
        public final String component9() {
            return this.filters;
        }

        @Nullable
        public final String component10() {
            return this.fields;
        }

        @Nullable
        public final List<String> component11() {
            return this.certificates;
        }

        @NotNull
        public final GetActiveConversationsRequestData copy(@NotNull String baseURL, @NotNull String siteId, @NotNull String lpToken, @NotNull String consumerId, @Nullable String limit, @Nullable String offset, @Nullable String sortBy, @Nullable String sortOrder, @Nullable String filters, @Nullable String fields, @Nullable List<String> certificates) {
            Intrinsics.checkNotNullParameter((Object)baseURL, (String)"baseURL");
            Intrinsics.checkNotNullParameter((Object)siteId, (String)"siteId");
            Intrinsics.checkNotNullParameter((Object)lpToken, (String)"lpToken");
            Intrinsics.checkNotNullParameter((Object)consumerId, (String)"consumerId");
            return new GetActiveConversationsRequestData(baseURL, siteId, lpToken, consumerId, limit, offset, sortBy, sortOrder, filters, fields, certificates);
        }

        public static /* synthetic */ GetActiveConversationsRequestData copy$default(GetActiveConversationsRequestData getActiveConversationsRequestData, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = getActiveConversationsRequestData.baseURL;
            }
            if ((n & 2) != 0) {
                string3 = getActiveConversationsRequestData.siteId;
            }
            if ((n & 4) != 0) {
                string4 = getActiveConversationsRequestData.lpToken;
            }
            if ((n & 8) != 0) {
                string5 = getActiveConversationsRequestData.consumerId;
            }
            if ((n & 0x10) != 0) {
                string6 = getActiveConversationsRequestData.limit;
            }
            if ((n & 0x20) != 0) {
                string7 = getActiveConversationsRequestData.offset;
            }
            if ((n & 0x40) != 0) {
                string8 = getActiveConversationsRequestData.sortBy;
            }
            if ((n & 0x80) != 0) {
                string9 = getActiveConversationsRequestData.sortOrder;
            }
            if ((n & 0x100) != 0) {
                string10 = getActiveConversationsRequestData.filters;
            }
            if ((n & 0x200) != 0) {
                string11 = getActiveConversationsRequestData.fields;
            }
            if ((n & 0x400) != 0) {
                list = getActiveConversationsRequestData.certificates;
            }
            return getActiveConversationsRequestData.copy(string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, list);
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("GetActiveConversationsRequestData(baseURL=").append(this.baseURL).append(", siteId=").append(this.siteId).append(", lpToken=").append(this.lpToken).append(", consumerId=").append(this.consumerId).append(", limit=").append(this.limit).append(", offset=").append(this.offset).append(", sortBy=").append(this.sortBy).append(", sortOrder=").append(this.sortOrder).append(", filters=").append(this.filters).append(", fields=").append(this.fields).append(", certificates=").append(this.certificates).append(')');
            return stringBuilder.toString();
        }

        public int hashCode() {
            int result = this.baseURL.hashCode();
            result = result * 31 + this.siteId.hashCode();
            result = result * 31 + this.lpToken.hashCode();
            result = result * 31 + this.consumerId.hashCode();
            result = result * 31 + (this.limit == null ? 0 : this.limit.hashCode());
            result = result * 31 + (this.offset == null ? 0 : this.offset.hashCode());
            result = result * 31 + (this.sortBy == null ? 0 : this.sortBy.hashCode());
            result = result * 31 + (this.sortOrder == null ? 0 : this.sortOrder.hashCode());
            result = result * 31 + (this.filters == null ? 0 : this.filters.hashCode());
            result = result * 31 + (this.fields == null ? 0 : this.fields.hashCode());
            result = result * 31 + (this.certificates == null ? 0 : ((Object)this.certificates).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GetActiveConversationsRequestData)) {
                return false;
            }
            GetActiveConversationsRequestData getActiveConversationsRequestData = (GetActiveConversationsRequestData)other;
            if (!Intrinsics.areEqual((Object)this.baseURL, (Object)getActiveConversationsRequestData.baseURL)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.siteId, (Object)getActiveConversationsRequestData.siteId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lpToken, (Object)getActiveConversationsRequestData.lpToken)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.consumerId, (Object)getActiveConversationsRequestData.consumerId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.limit, (Object)getActiveConversationsRequestData.limit)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.offset, (Object)getActiveConversationsRequestData.offset)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sortBy, (Object)getActiveConversationsRequestData.sortBy)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sortOrder, (Object)getActiveConversationsRequestData.sortOrder)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.filters, (Object)getActiveConversationsRequestData.filters)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fields, (Object)getActiveConversationsRequestData.fields)) {
                return false;
            }
            return Intrinsics.areEqual(this.certificates, getActiveConversationsRequestData.certificates);
        }
    }
}

