/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket.requests;

import androidx.annotation.Nullable;
import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.PublishEvent;
import com.liveperson.api.request.message.PublishMessage;
import com.liveperson.api.request.message.TextPublishMessage;
import com.liveperson.api.response.model.ContentType;
import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.ConversationUtils;
import com.liveperson.messaging.model.MessagingChatMessage;
import org.json.JSONException;
import org.json.JSONObject;

public class SendMessageRequest
extends BaseAMSSocketRequest<PublishEvent.Response, SendMessageRequest> {
    private static final String TAG = "SendMessageRequest";
    private final String mTargetId;
    private final String mEventId;
    private String mDialogId;
    private String mConversationId;
    protected PublishMessage mMessage;
    private PublishEvent.Type mType = PublishEvent.Type.ContentEvent;
    private ContentType mContentType = ContentType.text_plain;
    private Messaging mController;
    private DeliveryStatusUpdateInfo mInfo = null;

    public SendMessageRequest(Messaging controller, String eventId, String targetId, String brandId, String conversationId, String dialogId, String msg, ContentType contentType) {
        super(controller.mAccountsController.getConnectionUrl(brandId));
        this.mController = controller;
        this.mDialogId = dialogId;
        this.mConversationId = conversationId;
        this.mMessage = new TextPublishMessage(msg);
        this.mTargetId = targetId;
        this.mEventId = eventId;
        this.mContentType = contentType;
    }

    public SendMessageRequest(Messaging controller, String eventId, String targetId, String brandId, String dialogId, String msg, String conversationId) {
        super(controller.mAccountsController.getConnectionUrl(brandId));
        this.mController = controller;
        this.mDialogId = dialogId;
        this.mConversationId = conversationId;
        this.mMessage = new TextPublishMessage(msg);
        this.mTargetId = targetId;
        this.mEventId = eventId;
    }

    public SendMessageRequest(Messaging controller, String eventId, String targetId, String brandId, String dialogId, String conversationId) {
        super(controller.mAccountsController.getConnectionUrl(brandId));
        this.mController = controller;
        this.mDialogId = dialogId;
        this.mConversationId = conversationId;
        this.mTargetId = targetId;
        this.mEventId = eventId;
    }

    public void setMessageContent(String msg) {
        this.mMessage = new TextPublishMessage(msg);
    }

    public void setInfo(@Nullable DeliveryStatusUpdateInfo info) {
        LPLog.INSTANCE.d(TAG, "setInfo: Adding DeliveryStatusUpdateInfo with metadata: " + (info == null ? "null" : LPLog.INSTANCE.mask((Object)info.getMetadata())));
        this.mInfo = info;
    }

    public SendMessageRequest setConversationId(String conversationId) {
        this.mConversationId = conversationId;
        return this;
    }

    public SendMessageRequest setDialogId(String dialogId) {
        this.mDialogId = dialogId;
        return this;
    }

    public SendMessageRequest setContentType(ContentType contentType) {
        this.mContentType = contentType;
        return this;
    }

    public String getEventId() {
        return this.mEventId;
    }

    protected String getData() {
        return new PublishEvent(this.mDialogId, this.mConversationId, this.mMessage, this.mType, this.mContentType, this.mEventId, this.mInfo).toJsonString(this.getRequestId());
    }

    protected String getRequestName() {
        return TAG;
    }

    protected BaseResponseHandler<PublishEvent.Response, SendMessageRequest> getResponseHandler() {
        return new BaseResponseHandler<PublishEvent.Response, SendMessageRequest>(){

            public String getAPIResponseType() {
                return "ms.PublishEventResponse";
            }

            protected PublishEvent.Response parse(JSONObject jsonObject) throws JSONException {
                return new PublishEvent.Response(jsonObject);
            }

            protected boolean handle(PublishEvent.Response data) {
                int serverSequence = data.getBody().sequence;
                if (data.code != 200) {
                    LPLog.INSTANCE.e(SendMessageRequest.TAG, ErrorCode.ERR_000000AA, "Error occurred while sending message: " + data.getBody());
                    ((SendMessageRequest)SendMessageRequest.this).mController.amsMessages.updateMessageState(SendMessageRequest.this.mEventId, MessagingChatMessage.MessageState.ERROR);
                } else {
                    ((SendMessageRequest)SendMessageRequest.this).mController.amsMessages.updateOnMessageAck(SendMessageRequest.this.mEventId, serverSequence);
                    ((SendMessageRequest)SendMessageRequest.this).mController.amsDialogs.updateLastServerSequenceByDialogId(SendMessageRequest.this.mDialogId, serverSequence);
                }
                LPLog.INSTANCE.i(SendMessageRequest.TAG, "Got send message response eventId = " + SendMessageRequest.this.mEventId + ", with sequence = " + serverSequence);
                ((SendMessageRequest)SendMessageRequest.this).mController.amsMessages.mMessageTimeoutQueue.remove((int)SendMessageRequest.this.getRequestId());
                ConversationUtils.showTTR(SendMessageRequest.this.mController, SendMessageRequest.this.mTargetId);
                return true;
            }

            protected void giveUp() {
                super.giveUp();
                LPLog.INSTANCE.i(SendMessageRequest.TAG, SendMessageRequest.this.getRequestId() + ": Request lost (socket closed) for send message request.");
                DataBaseExecutor.execute(() -> SendMessageRequest.this.mController.getOfflineManager().removePendingOfflineMessage(SendMessageRequest.this.mController.getActiveBrandId(), SendMessageRequest.this.getEventId()));
                ((SendMessageRequest)SendMessageRequest.this).mController.amsMessages.mMessageTimeoutQueue.remove((int)SendMessageRequest.this.getRequestId());
            }
        };
    }
}

