package com.liveperson.messaging.controller.connection

import com.liveperson.infra.model.types.FailureReason
import com.liveperson.infra.statemachine.interfaces.IEvent
import com.liveperson.infra.statemachine.interfaces.IState
import com.liveperson.infra.statemachine.interfaces.IStateMachine
import com.liveperson.messaging.LpError
import com.liveperson.messaging.TaskType
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionCallback
import com.liveperson.messaging.controller.connection.connectionevents.SecondaryTaskSuccessEvent
import com.liveperson.messaging.controller.connection.connectionevents.TaskFailedEvent
import com.liveperson.messaging.controller.connection.connectionevents.TaskSuccessEvent

/**
 * Created by shiranr on 14/03/2016.
 */
open class DefaultTaskCallbackAmsAccount(
    private val mStateMachine: IStateMachine<IState>?,
    protected var mTaskName: String
) : BaseAmsAccountConnectionCallback {
    private var mSecondaryTask = false
    override fun onTaskSuccess() {
        val taskToSend: IEvent = if (mSecondaryTask) {
            SecondaryTaskSuccessEvent(mTaskName)
        } else {
            TaskSuccessEvent(mTaskName)
        }
        mStateMachine?.postEvent(taskToSend)
    }

    override fun onTaskError(type: TaskType, lpError: LpError, exception: Exception) {
        mStateMachine?.postEvent(TaskFailedEvent(mTaskName, type, lpError, exception))
    }

    override fun onTaskError(
        type: TaskType,
        lpError: LpError,
        reason: FailureReason,
        exception: Exception
    ) {
        mStateMachine?.postEvent(TaskFailedEvent(mTaskName, type, lpError, reason, exception))
    }

    override fun setSecondaryTask(secondaryTask: Boolean) {
        mSecondaryTask = secondaryTask
    }
}