@file:JvmName("MessagingCommands")
package com.liveperson.messaging.hybrid

import com.liveperson.infra.ICallback
import com.liveperson.messaging.MessagingFactory
import com.liveperson.messaging.hybrid.commands.base.HybridSDKCommand
import com.liveperson.messaging.hybrid.commands.exceptions.HybridSDKException
import com.liveperson.messaging.hybrid.commands.exceptions.InternalHybridSDKException
import com.liveperson.messaging.hybrid.commands.messaging.SendMessageHybridSDKCommand

/**
 * Entry point for hybrid command execution.
 * This method validates SDK state, connection or conversation state, and configuration values
 * to perform hybrid sdk command or return a type of HybridSDKException.
 */
fun<T> execute(command: HybridSDKCommand<T>, callback: ICallback<T, HybridSDKException>) {
    try {
        val messaging = MessagingFactory.getInstance().controller.requireInitialization()
        command.execute(messaging, callback)
    } catch (throwable: HybridSDKException) {
        callback.onError(throwable)
    } catch (throwable: Exception) {
        callback.onError(InternalHybridSDKException(message = "Internal error", cause = throwable))
    }
}

/**
 * Method used to send message outside from any user inputs provided by LP SDK UI.
 */
fun sendMessage(message: String, callback: ICallback<Unit, HybridSDKException>) {
    execute(SendMessageHybridSDKCommand(message), callback)
}