/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.ICallback;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionTask;
import com.liveperson.messaging.controller.ConnectionsController;
import com.liveperson.messaging.model.AmsAccount;
import com.liveperson.messaging.model.AmsConversations;
import com.liveperson.messaging.model.AmsUsers;
import com.liveperson.messaging.model.ConversationField;
import com.liveperson.messaging.network.socket.requests.UpdateConversationFieldRequest;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0014H\u0002J\u0012\u0010\u0015\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/liveperson/messaging/commands/tasks/UpdateConversationFieldTask;", "Lcom/liveperson/messaging/commands/tasks/BaseAmsSocketConnectionTask;", "controller", "Lcom/liveperson/messaging/Messaging;", "(Lcom/liveperson/messaging/Messaging;)V", "CONSUMER", "", "OPEN_CONVERSATION_ERROR", "PARTICIPANTS_CHANGE_FIELD", "TAG", "TYPE_ADD", "TYPE_REMOVE", "getController", "()Lcom/liveperson/messaging/Messaging;", "conversationId", "execute", "", "generateConversationFieldArray", "Ljava/util/ArrayList;", "Lcom/liveperson/messaging/model/ConversationField;", "Lkotlin/collections/ArrayList;", "sanitizeText", "text", "messaging_release"})
public final class UpdateConversationFieldTask
extends BaseAmsSocketConnectionTask {
    @NotNull
    private final Messaging controller;
    @NotNull
    private final String TAG;
    @NotNull
    private final String OPEN_CONVERSATION_ERROR;
    @NotNull
    private final String PARTICIPANTS_CHANGE_FIELD;
    @NotNull
    private final String TYPE_ADD;
    @NotNull
    private final String TYPE_REMOVE;
    @NotNull
    private final String CONSUMER;
    @Nullable
    private String conversationId;

    public UpdateConversationFieldTask(@NotNull Messaging controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        this.controller = controller;
        this.TAG = "UpdateConversationFieldTask";
        this.OPEN_CONVERSATION_ERROR = "Failed to update conversation field, response: Consumer step up failed.  User already has open conversation";
        this.PARTICIPANTS_CHANGE_FIELD = "ParticipantsChange";
        this.TYPE_ADD = "ADD";
        this.TYPE_REMOVE = "REMOVE";
        this.CONSUMER = "CONSUMER";
    }

    @NotNull
    public final Messaging getController() {
        return this.controller;
    }

    public void execute() {
        CharSequence charSequence;
        Boolean performStepUp;
        LPLog.INSTANCE.i(this.TAG, "Running UpdateConversationFieldTask task...");
        AmsAccount amsAccount = this.controller.mAccountsController.getAccount(this.mBrandId);
        Boolean bl = performStepUp = amsAccount != null ? Boolean.valueOf(amsAccount.isPerformStepUp()) : null;
        if (Intrinsics.areEqual((Object)performStepUp, (Object)false)) {
            this.mCallback.onTaskSuccess();
            LPLog.INSTANCE.d(this.TAG, "Step up disabled. No request");
            return;
        }
        LPLog.INSTANCE.i(this.TAG, "Step up is enabled. Send request to update conversation participants");
        ArrayList<ConversationField> conversationFieldList = this.generateConversationFieldArray();
        String socketUrl = this.controller.mAccountsController.getConnectionUrl(this.mBrandId);
        if (!((Collection)conversationFieldList).isEmpty() && !((charSequence = (CharSequence)socketUrl) == null || charSequence.length() == 0) && !((charSequence = (CharSequence)this.conversationId) == null || charSequence.length() == 0)) {
            Intrinsics.checkNotNullExpressionValue((Object)socketUrl, (String)"socketUrl");
            String string2 = this.conversationId;
            Intrinsics.checkNotNull((Object)string2);
            UpdateConversationFieldRequest conversationFieldRequest = new UpdateConversationFieldRequest(socketUrl, string2, conversationFieldList);
            conversationFieldRequest.setResponseCallBack((ICallback<String, Throwable>)((ICallback)new ICallback<String, Throwable>(this){
                final /* synthetic */ UpdateConversationFieldTask this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onSuccess(@Nullable String value) {
                    LPLog.INSTANCE.d(UpdateConversationFieldTask.access$getTAG$p(this.this$0), "Successfully updated conversation fields: " + value);
                    AmsAccount amsAccount = this.this$0.getController().mAccountsController.getAccount(this.this$0.mBrandId);
                    if (amsAccount != null) {
                        amsAccount.setPerformStepUp(false);
                    }
                    this.this$0.mCallback.onTaskSuccess();
                }

                public void onError(@Nullable Throwable exception) {
                    LPLog.INSTANCE.e(UpdateConversationFieldTask.access$getTAG$p(this.this$0), ErrorCode.ERR_00000164, "Failed to update conversation field, response: " + exception);
                    AmsAccount amsAccount = this.this$0.getController().mAccountsController.getAccount(this.this$0.mBrandId);
                    if (amsAccount != null) {
                        amsAccount.setPerformStepUp(false);
                    }
                    Throwable throwable = exception;
                    CharSequence charSequence = throwable != null ? throwable.getMessage() : null;
                    if (!(charSequence == null || charSequence.length() == 0)) {
                        Throwable throwable2 = exception;
                        if (Intrinsics.areEqual((Object)UpdateConversationFieldTask.access$sanitizeText(this.this$0, throwable2 != null ? throwable2.getMessage() : null), (Object)UpdateConversationFieldTask.access$sanitizeText(this.this$0, UpdateConversationFieldTask.access$getOPEN_CONVERSATION_ERROR$p(this.this$0)))) {
                            ConnectionsController connectionsController = this.this$0.getController().mConnectionController;
                            if (connectionsController != null) {
                                connectionsController.notifySocketTaskFailure(this.this$0.mBrandId, LpError.STEP_UP_FAILURE, exception);
                            }
                            this.this$0.mCallback.onTaskSuccess();
                            return;
                        }
                    }
                    this.this$0.mCallback.onTaskError(SocketTaskType.UPDATE_CONVERSATION_FIELD, exception);
                }
            }));
            LPLog.INSTANCE.d(this.TAG, "Updating conversation participants");
            SocketManager.getInstance().send((BaseSocketRequest)conversationFieldRequest);
        } else {
            LPLog.INSTANCE.w(this.TAG, "Cannot update conversation field. conversationFieldList size: " + conversationFieldList.size() + ", socketUrl: " + socketUrl + ", conversationId: " + this.conversationId);
            ConnectionsController connectionsController = this.controller.mConnectionController;
            if (connectionsController != null) {
                connectionsController.notifySocketTaskFailure(this.mBrandId, LpError.STEP_UP_FAILURE, new Exception("Failed to update conversation field. Missing data."));
            }
            this.mCallback.onTaskSuccess();
        }
    }

    private final ArrayList<ConversationField> generateConversationFieldArray() {
        ArrayList<ConversationField> conversationFieldList = new ArrayList<ConversationField>();
        try {
            AmsUsers amsUsers = this.controller.amsUsers;
            String oldConsumerId = amsUsers != null ? amsUsers.getStepUpConsumerId() : null;
            AmsUsers amsUsers2 = this.controller.amsUsers;
            String newConsumerId = amsUsers2 != null ? amsUsers2.getConsumerId(this.mBrandId) : null;
            AmsConversations amsConversations = this.controller.amsConversations;
            String cachedConversationId = amsConversations != null ? amsConversations.getConversationIdInPreferences(this.mBrandId) : null;
            CharSequence charSequence = oldConsumerId;
            if (!(charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)newConsumerId) == null || charSequence.length() == 0 || (charSequence = (CharSequence)cachedConversationId) == null || charSequence.length() == 0)) {
                this.conversationId = cachedConversationId;
                conversationFieldList.add(new ConversationField(this.PARTICIPANTS_CHANGE_FIELD, this.TYPE_REMOVE, oldConsumerId, this.CONSUMER));
                conversationFieldList.add(new ConversationField(this.PARTICIPANTS_CHANGE_FIELD, this.TYPE_ADD, newConsumerId, this.CONSUMER));
            } else {
                LPLog.INSTANCE.w(this.TAG, "Missing data to form ConversationField. oldConsumerId: " + oldConsumerId + ", newConsumerId: " + newConsumerId + ", cachedConversationId: " + cachedConversationId);
            }
        }
        catch (Exception exception) {
            LPLog.INSTANCE.w(this.TAG, "Failed to get data to form ConversationField. " + exception);
        }
        return conversationFieldList;
    }

    private final String sanitizeText(String text) {
        CharSequence charSequence = text;
        if (charSequence == null || charSequence.length() == 0) {
            return "";
        }
        charSequence = text;
        Regex regex = new Regex("\\s");
        String string2 = "";
        return regex.replace(charSequence, string2);
    }

    public static final /* synthetic */ String access$getTAG$p(UpdateConversationFieldTask $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ String access$sanitizeText(UpdateConversationFieldTask $this, String text) {
        return $this.sanitizeText(text);
    }

    public static final /* synthetic */ String access$getOPEN_CONVERSATION_ERROR$p(UpdateConversationFieldTask $this) {
        return $this.OPEN_CONVERSATION_ERROR;
    }
}

