/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.background.CoBrowseManager;
import org.json.JSONException;
import org.json.JSONObject;

public class CoBrowseMetadata {
    private static final String TAG = "CoBrowseMetadata";
    public static final String COLLABORATION_CALL_INVITED = "COLLABORATION_CALL_INVITED";
    public static final String COLLABORATION_CALL_ACCEPTED = "COLLABORATION_CALL_ACCEPTED";
    public static final String COLLABORATION_CALL_DECLINED = "COLLABORATION_CALL_DECLINED";
    public static final String COLLABORATION_CALL_ENDED = "COLLABORATION_CALL_ENDED";
    public static final String COLLABORATION_CALL_ENDED_BY_CONSUMER = "COLLABORATION_CALL_ENDED_BY_CONSUMER";
    public static final String COLLABORATION_CALL_ENDED_BY_AGENT = "COLLABORATION_CALL_ENDED_BY_AGENT";
    public static final String COLLABORATION_CALL_TIMEOUT = "COLLABORATION_CALL_TIMEOUT";
    public static final String COLLABORATION_CALL_NOT_JOINED = "COLLABORATION_CALL_NOT_JOINED";
    public static final String COLLABORATION_CALL_JOINED = "COLLABORATION_CALL_JOINED";
    public static final String COLLABORATION_CALL_CANCEL_INVITATION = "COLLABORATION_CALL_CANCEL_INVITATION";
    public static final String COLLABORATION_CALL_CONSUMER_LEFT = "COLLABORATION_CALL_CONSUMER_LEFT";
    public String serviceId;
    public double expires;
    public String sessionState;
    public String dialogId;
    public String mode;
    public String notificationKey;
    public String callLink;

    public CoBrowseMetadata(JSONObject obj) {
        try {
            if (obj.has("dialogId")) {
                this.dialogId = obj.getString("dialogId");
            }
            if (obj.has("expires")) {
                this.expires = obj.getDouble("expires");
            }
            if (obj.has("sessionState")) {
                this.sessionState = obj.getString("sessionState");
            }
            if (obj.has("serviceId")) {
                this.serviceId = obj.getString("serviceId");
            }
            if (obj.has("mode")) {
                this.mode = obj.getString("mode");
            }
            if (obj.has("notificationKey")) {
                this.notificationKey = obj.getString("notificationKey");
            }
            if (obj.has("callLink")) {
                this.callLink = obj.getString("callLink");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public JSONObject getJsonObject() {
        try {
            JSONObject obj = new JSONObject();
            obj.put("serviceId", (Object)this.serviceId);
            obj.put("expires", this.expires);
            obj.put("sessionState", (Object)this.sessionState);
            obj.put("dialogId", (Object)this.dialogId);
            obj.put("mode", (Object)this.mode);
            obj.put("notificationKey", (Object)this.notificationKey);
            obj.put("callLink", (Object)this.callLink);
            return obj;
        }
        catch (JSONException e) {
            LPLog.INSTANCE.w(TAG, "getJsonString: error parsing quick reply json", (Throwable)e);
            return null;
        }
    }

    public String getAutomaticMessageKey() {
        if ("invited".equals(this.notificationKey)) {
            return COLLABORATION_CALL_INVITED;
        }
        if ("accepted".equals(this.notificationKey)) {
            return COLLABORATION_CALL_ACCEPTED;
        }
        if ("declined".equals(this.notificationKey)) {
            return COLLABORATION_CALL_DECLINED;
        }
        if ("ended".equals(this.notificationKey)) {
            return COLLABORATION_CALL_ENDED;
        }
        if ("ended_by_consumer".equals(this.notificationKey)) {
            return COLLABORATION_CALL_ENDED_BY_CONSUMER;
        }
        if ("ended_by_agent".equals(this.notificationKey)) {
            return COLLABORATION_CALL_ENDED_BY_AGENT;
        }
        if ("timeout".equals(this.notificationKey)) {
            return COLLABORATION_CALL_TIMEOUT;
        }
        if ("not_joined".equals(this.notificationKey)) {
            return COLLABORATION_CALL_NOT_JOINED;
        }
        if ("joined".equals(this.notificationKey)) {
            return COLLABORATION_CALL_JOINED;
        }
        if ("cancel_invitation".equals(this.notificationKey)) {
            return COLLABORATION_CALL_CANCEL_INVITATION;
        }
        if ("consumer_left".equals(this.notificationKey)) {
            return COLLABORATION_CALL_CONSUMER_LEFT;
        }
        return null;
    }

    public boolean isJoined() {
        return CoBrowseManager.NOTIFICATION_KEY_JOINED.equals(this.notificationKey);
    }

    public boolean isJoinable() {
        if ((CoBrowseManager.NOTIFICATION_KEY_JOINED.equals(this.notificationKey) || CoBrowseManager.NOTIFICATION_KEY_ACCEPTED.equals(this.notificationKey)) && CoBrowseManager.STATUS_ACCEPTED.equals(this.sessionState)) {
            return true;
        }
        if (CoBrowseManager.NOTIFICATION_KEY_INVITED.equals(this.notificationKey) && CoBrowseManager.STATUS_INVITED.equals(this.sessionState)) {
            return true;
        }
        return CoBrowseManager.NOTIFICATION_KEY_CONSUMER_LEFT.equals(this.notificationKey) && CoBrowseManager.STATUS_ACCEPTED.equals(this.sessionState);
    }

    public boolean isInvite() {
        return CoBrowseManager.STATUS_INVITED.equals(this.sessionState);
    }

    public boolean isPresentable() {
        return this.isClosed() ? false : this.isInvite() || this.isJoinable();
    }

    public boolean isClosed() {
        return CoBrowseManager.STATUS_CLOSED.equals(this.sessionState);
    }

    public boolean isVideoCall() {
        return CoBrowseManager.MODE_VIDEO_CALL.equals(this.mode);
    }

    public boolean isVoiceCall() {
        return CoBrowseManager.MODE_VOICE_CALL.equals(this.mode);
    }
}

