/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket.requests;

import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.ReqBody;
import com.liveperson.api.request.UpdateConversationField;
import com.liveperson.api.response.types.CsatStatus;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import org.json.JSONException;
import org.json.JSONObject;

public class CsatRequest
extends BaseAMSSocketRequest<ReqBody.StringResp, CsatRequest> {
    private static final String TAG = "CsatRequest";
    private String conversationId;
    private int numOfStars;
    private int isHelpful;
    private CsatStatus csatStatus;

    public CsatRequest(String socketUrl, String convServerId, int numOfStars, int isHelpful) {
        super(socketUrl);
        this.conversationId = convServerId;
        this.numOfStars = numOfStars;
        this.isHelpful = isHelpful;
        this.csatStatus = numOfStars > 0 && isHelpful > 0 ? CsatStatus.FILLED : (numOfStars == -1 && isHelpful == -1 ? CsatStatus.SKIPPED : CsatStatus.PARTIALLY_FILLED);
    }

    protected String getData() {
        return new UpdateConversationField(this.conversationId, "CSATRate", this.numOfStars, this.isHelpful, this.csatStatus).toJsonString(this.getRequestId());
    }

    protected String getRequestName() {
        return TAG;
    }

    protected BaseResponseHandler<ReqBody.StringResp, CsatRequest> getResponseHandler() {
        return new BaseResponseHandler<ReqBody.StringResp, CsatRequest>(){

            public String getAPIResponseType() {
                return "StringResponse";
            }

            protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
                return new ReqBody.StringResp(jsonObject);
            }

            protected boolean handle(ReqBody.StringResp data) {
                LPLog.INSTANCE.d(CsatRequest.TAG, "Got resolve response: " + data.getBody());
                return true;
            }
        };
    }
}

