package com.liveperson.messaging.hybrid.commands.base

import com.liveperson.infra.ICallback
import com.liveperson.messaging.Messaging
import com.liveperson.messaging.hybrid.commands.exceptions.HybridSDKException

/**
 * Contract between brand's app and SDK to execute hybrid command.
 * This command encapsulates interaction with messaging controller to operate with state of sdk and
 * configuration values.
 */
interface HybridSDKCommand<T> {

    /**
     * Entry point of Hybrid SDK command.
     * @param messaging MessagingController that is validated for initialization
     * @param callback callback to notify about HybridSDKCommand result(success with type [T]
     * if Hybrid SDK Command was executed successfully or [HybridSDKException] otherwise).
     *
     * @see HybridSDKException and its extended classes.
     */
    fun execute(messaging: Messaging, callback: ICallback<T, HybridSDKException>)
}