/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.SendDocumentCommand;
import com.liveperson.messaging.model.MessagingChatMessage;

public class ReSendDocumentCommand
extends SendDocumentCommand {
    private long mFileRowId;

    public ReSendDocumentCommand(Messaging controller, String targetId, String brandId, String contentType, String thumbnailPath, String filePath, String fileTypeExtension, MaskedMessage message, String previewContentType, String eventId, long fileRowId) {
        super(controller, targetId, brandId, contentType, thumbnailPath, filePath, fileTypeExtension, message, previewContentType);
        this.mFileRowId = fileRowId;
        this.mEventId = eventId;
    }

    @Override
    protected void addMessageToDBAndSend(String conversationId, MaskedMessage message, MessagingChatMessage.MessageState state) {
        this.mController.amsMessages.updateMessageState(this.mEventId, MessagingChatMessage.MessageState.QUEUED);
        this.mController.amsMessages.getRowIdByEventId(this.mEventId).setPostQueryOnBackground(data -> {
            this.mMessageRowId = data;
            if (this.mCallback != null) {
                this.mCallback.onFileAddedToDB(this.mMessageRowId, this.mFileRowId, false);
            }
        }).execute();
    }

    @Override
    protected boolean canSendWhileOffline() {
        return false;
    }
}

