/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.http;

import android.text.TextUtils;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.infra.otel.LPTraceType;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.AcUserData;
import com.liveperson.messaging.model.AcUserType;
import com.liveperson.messaging.model.MessagingUserProfile;
import java.util.Set;

public class AgentProfileRequest
implements Command {
    private static final String TAG = "AgentProfileRequest";
    private static final String AC_USERS_URL = "https://%s/api/account/%s/configuration/le-users/users/%s";
    private static final int AGENT_REQUEST_TIMEOUT = 30000;
    private final Messaging mController;
    private final String mBrand;
    private final String mUserId;
    private final String mDialogId;
    private final boolean mShouldUpdateUI;
    private ICallback<MessagingUserProfile, Exception> callback;

    public AgentProfileRequest(Messaging controller, String brand, String userId, String dialogId, boolean shouldUpdateUi) {
        this.mBrand = brand;
        this.mUserId = userId;
        this.mDialogId = dialogId;
        this.mShouldUpdateUI = shouldUpdateUi;
        this.mController = controller;
    }

    public void execute() {
        String acCdnDomain = this.mController.mAccountsController.getServiceUrl(this.mBrand, "acCdnDomain");
        if (!TextUtils.isEmpty((CharSequence)acCdnDomain)) {
            String cSDSRequestUrl = String.format(AC_USERS_URL, acCdnDomain, this.mBrand, this.mUserId);
            LPLog.INSTANCE.d(TAG, "Getting agent details url " + cSDSRequestUrl);
            HttpGetRequest httpGetRequest = new HttpGetRequest(cSDSRequestUrl, LPTraceType.ACCDN_USER_DETAILS_REQ);
            httpGetRequest.setTimeout(30000);
            httpGetRequest.setCallback((ICallback)new ICallback<String, Exception>(){

                public void onSuccess(String profile) {
                    if (!TextUtils.isEmpty((CharSequence)profile)) {
                        LPLog.INSTANCE.d(AgentProfileRequest.TAG, "onSuccess with agent details " + profile);
                        AgentProfileRequest.this.onRequestCompleted();
                        AcUserData userData = new AcUserData(profile);
                        MessagingUserProfile userProfile = new MessagingUserProfile(userData.getFirstName(), userData.getLastName(), UserProfile.UserType.AGENT);
                        userProfile.setNickname(userData.getNickName());
                        userProfile.setBrandID(AgentProfileRequest.this.mBrand);
                        userProfile.setDescription(userData.getEmployeeId());
                        userProfile.setOriginatorID(AgentProfileRequest.this.mUserId);
                        userProfile.setAvatarUrl(userData.getPictureUrl());
                        userProfile.setEmail(userData.getEmail());
                        if (userData.getUserType().equals((Object)AcUserType.BOT) || userData.getUserType().equals((Object)AcUserType.CONTROLLER)) {
                            DataBaseExecutor.execute(() -> {
                                Set<String> botUsers = AgentProfileRequest.this.mController.amsUsers.getBotUserIds(AgentProfileRequest.this.mBrand);
                                if (botUsers.add(AgentProfileRequest.this.mUserId)) {
                                    AgentProfileRequest.this.mController.amsUsers.setBotUserIds(AgentProfileRequest.this.mBrand, botUsers);
                                    if (AgentProfileRequest.this.mDialogId != null && AgentProfileRequest.this.mUserId != null) {
                                        AgentProfileRequest.this.mController.amsMessages.updateBotMessagesForDialog(AgentProfileRequest.this.mDialogId, AgentProfileRequest.this.mUserId).execute();
                                    } else {
                                        Set<String> syncedDialogs = AgentProfileRequest.this.mController.amsDialogs.getSyncedDialogIds();
                                        for (String dialogId : syncedDialogs) {
                                            AgentProfileRequest.this.mController.amsMessages.updateBotMessagesForDialog(dialogId, AgentProfileRequest.this.mUserId).execute();
                                        }
                                    }
                                }
                            });
                        }
                        AgentProfileRequest.this.mController.amsMessages.onAgentReceived(userProfile);
                        AgentProfileRequest.this.mController.amsUsers.updateUserProfile(userProfile);
                        if (AgentProfileRequest.this.callback != null) {
                            AgentProfileRequest.this.callback.onSuccess((Object)userProfile);
                        }
                        if (TextUtils.isEmpty((CharSequence)AgentProfileRequest.this.mDialogId)) {
                            LPLog.INSTANCE.d(AgentProfileRequest.TAG, "onResult: updating agent details. without conversation id.");
                            return;
                        }
                        AgentProfileRequest.this.mController.amsDialogs.queryDialogById(AgentProfileRequest.this.mDialogId).setPostQueryOnBackground(data -> {
                            if (data != null && TextUtils.equals((CharSequence)data.getAssignedAgentId(), (CharSequence)AgentProfileRequest.this.mUserId)) {
                                LPLog.INSTANCE.d(AgentProfileRequest.TAG, "onResult: Calling agent details callback");
                                AgentProfileRequest.this.mController.onAgentDetailsChanged(userProfile, data.isOpen());
                            }
                            LPLog.INSTANCE.d(AgentProfileRequest.TAG, "got agent details (" + AgentProfileRequest.this.mUserId + ") related to dialog ID: " + AgentProfileRequest.this.mDialogId);
                            if (AgentProfileRequest.this.mShouldUpdateUI) {
                                LPLog.INSTANCE.d(AgentProfileRequest.TAG, "Updating ui with agent details! ");
                                AgentProfileRequest.this.mController.amsMessages.updateAgentDetailsUpdated(AgentProfileRequest.this.mDialogId);
                            }
                        }).execute();
                    } else if (AgentProfileRequest.this.callback != null) {
                        AgentProfileRequest.this.callback.onError((Throwable)new Exception("Empty response"));
                    }
                }

                public void onError(Exception exception) {
                    LPLog.INSTANCE.e(AgentProfileRequest.TAG, ErrorCode.ERR_000000C6, "JSONException", (Throwable)exception);
                    if (AgentProfileRequest.this.callback != null) {
                        AgentProfileRequest.this.callback.onError((Throwable)exception);
                    }
                }
            });
            HttpHandler.execute((HttpRequest)httpGetRequest);
            this.onRequestSent();
        }
    }

    private void onRequestSent() {
        if (!TextUtils.isEmpty((CharSequence)this.mDialogId)) {
            this.mController.amsDialogs.addUpdateRequestInProgress(this.mDialogId);
        }
    }

    private void onRequestCompleted() {
        if (!TextUtils.isEmpty((CharSequence)this.mDialogId)) {
            this.mController.amsDialogs.removeUpdateRequestInProgress(this.mDialogId);
        }
    }

    public ICallback<MessagingUserProfile, Exception> getCallback() {
        return this.callback;
    }

    public AgentProfileRequest setCallback(ICallback<MessagingUserProfile, Exception> callback) {
        this.callback = callback;
        return this;
    }
}

