/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.http;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.infra.otel.LPTraceType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u0012 \b\u0002\u0010\u0007\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\f\u0012\n\u0018\u00010\tj\u0004\u0018\u0001`\n\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0016J \u0010\u0011\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\f\u0012\n\u0018\u00010\tj\u0004\u0018\u0001`\n\u0018\u00010\bH\u0002R&\u0010\u0007\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\f\u0012\n\u0018\u00010\tj\u0004\u0018\u0001`\n\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/liveperson/messaging/network/http/GetPendingProactiveMessagesRequest;", "Lcom/liveperson/infra/Command;", "requestURL", "", "token", "certificates", "", "callback", "Lcom/liveperson/infra/ICallback;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lcom/liveperson/infra/ICallback;)V", "addHeaders", "", "httpGetRequest", "Lcom/liveperson/infra/network/http/request/HttpGetRequest;", "execute", "setCallback", "Companion", "messaging_release"})
public final class GetPendingProactiveMessagesRequest
implements Command {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String requestURL;
    @NotNull
    private final String token;
    @Nullable
    private final List<String> certificates;
    @Nullable
    private final ICallback<String, Exception> callback;
    @NotNull
    private static final String TAG = "GetPendingProactiveMessagesRequest";
    private static final int REQUEST_TIMEOUT = 30000;

    public GetPendingProactiveMessagesRequest(@NotNull String requestURL, @NotNull String token, @Nullable List<String> certificates, @Nullable ICallback<String, Exception> callback) {
        Intrinsics.checkNotNullParameter((Object)requestURL, (String)"requestURL");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.requestURL = requestURL;
        this.token = token;
        this.certificates = certificates;
        this.callback = callback;
    }

    public /* synthetic */ GetPendingProactiveMessagesRequest(String string2, String string3, List list, ICallback iCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = null;
        }
        if ((n & 8) != 0) {
            iCallback = null;
        }
        this(string2, string3, list, (ICallback<String, Exception>)iCallback);
    }

    public void execute() {
        HttpGetRequest httpGetRequest = new HttpGetRequest(this.requestURL, LPTraceType.PUSHER_GET_PENDING_PROACTIVE_MESSAGES_REQ);
        httpGetRequest.setTimeout(30000);
        this.addHeaders(httpGetRequest);
        httpGetRequest.setCertificatePinningKeys(this.certificates);
        httpGetRequest.setCallback(this.setCallback());
        HttpHandler.execute((HttpRequest)((HttpRequest)httpGetRequest));
    }

    private final void addHeaders(HttpGetRequest httpGetRequest) {
        httpGetRequest.addHeader("Authorization", "Bearer " + this.token);
    }

    private final ICallback<String, Exception> setCallback() {
        return (ICallback)new ICallback<String, Exception>(this){
            final /* synthetic */ GetPendingProactiveMessagesRequest this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@Nullable String value) {
                block2: {
                    LPLog.INSTANCE.d("GetPendingProactiveMessagesRequest", "onSuccess " + value);
                    CharSequence charSequence = value;
                    if (!(charSequence == null || charSequence.length() == 0)) {
                        ICallback iCallback = GetPendingProactiveMessagesRequest.access$getCallback$p(this.this$0);
                        if (iCallback != null) {
                            iCallback.onSuccess((Object)value);
                        }
                        return;
                    }
                    ICallback iCallback = GetPendingProactiveMessagesRequest.access$getCallback$p(this.this$0);
                    if (iCallback == null) break block2;
                    iCallback.onError((Throwable)new Exception("Get empty result"));
                }
            }

            public void onError(@Nullable Exception exception) {
                block0: {
                    Exception exception2 = exception;
                    String string2 = exception2 != null ? exception2.getMessage() : null;
                    Intrinsics.checkNotNull((Object)string2);
                    LPLog.INSTANCE.e("GetPendingProactiveMessagesRequest", ErrorCode.ERR_0000016H, string2);
                    ICallback iCallback = GetPendingProactiveMessagesRequest.access$getCallback$p(this.this$0);
                    if (iCallback == null) break block0;
                    iCallback.onError((Throwable)exception);
                }
            }
        };
    }

    public static final /* synthetic */ ICallback access$getCallback$p(GetPendingProactiveMessagesRequest $this) {
        return $this.callback;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/liveperson/messaging/network/http/GetPendingProactiveMessagesRequest$Companion;", "", "()V", "REQUEST_TIMEOUT", "", "TAG", "", "messaging_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

