package com.liveperson.api.request;

import com.liveperson.api.response.AbstractResponse;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Shayl on 8/9/2015.
 */
public class ReqBody extends AbstractRequest {

    private static final String REQ_BODY_TYPE = ".ReqBody";

    public ReqBody() {
        super();
    }

    @Override
    public String getMessageType() {
        return REQ_BODY_TYPE;
    }

    @Override
    protected void toJson(JSONObject json) throws JSONException {
        json.put(JSON_KEY_BODY, new JSONObject());
    }


    public static class StringResp extends AbstractResponse<String> {
        public static final String REQ_BODY_RESPONSE_TYPE ="StringResponse";

        String body;

        public StringResp(JSONObject obj) throws JSONException {
            super(obj);
            body = obj.getString(JSON_KEY_BODY);
        }

        public String getBody() {
            return body;
        }

        @Override
        public String toString() {
            return getBody();
        }
    }
}
