package com.liveperson.api.request.message;

import com.liveperson.infra.log.LPLog;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by shiranr on 03/07/2016.
 */
public class FilePublishMessage extends BasePublishMessage {

    private static final String TAG = "FilePublishMessage";

    public static final String CAPTION = "caption";
    public static final String RELATIVE_PATH = "relativePath";
    public static final String FILE_TYPE = "fileType";
    public static final String PREVIEW = "preview";

    private String caption;
    private String relativePath;
    private String fileType;
    private String preview;

    public FilePublishMessage(String caption, String relativePath, String fileType, String preview) {
        this.caption = caption;
        this.relativePath = relativePath;
        this.fileType = fileType;
        this.preview = preview;
    }

	/**
	 * Build a PublishMessage from a JSONObject
	 * @param jsonObject
	 */
	public FilePublishMessage(JSONObject jsonObject) {

		if (jsonObject != null) {
			caption = jsonObject.optString(CAPTION);
			caption = caption.trim();
			relativePath = jsonObject.optString(RELATIVE_PATH);
			fileType = jsonObject.optString(FILE_TYPE);
			preview = jsonObject.optString(PREVIEW);
		}
	}

	@Override
    public JSONObject getMessage() {
        JSONObject msgJson = new JSONObject();
        try {
            msgJson.put(CAPTION, caption);
            msgJson.put(RELATIVE_PATH,relativePath);
            msgJson.put(FILE_TYPE, fileType);
            msgJson.put(PREVIEW, preview);
        } catch (JSONException e) {
            LPLog.INSTANCE.d(TAG, "Can't create file message:");
        }
        return msgJson;
    }

	@Override
	public PublishMessageType getType() {
		return PublishMessageType.FILE;
	}

	@Override
	public String getMessageText() {
		return getMessageTextWithoutSpecialChars(caption);
	}

	public String getCaption() {
		return caption;
	}

	public String getRelativePath() {
		return relativePath;
	}

	public String getFileType() {
		return fileType;
	}

	public String getPreview() {
		return preview;
	}
}
