package com.liveperson.messaging.background.filesharing;

import android.webkit.MimeTypeMap;

/**
 * Describes the type of file to be shared
 */
public enum FileSharingType {
    PDF(CommonFileType.DOCUMENT),
    DOCX(CommonFileType.DOCUMENT), PPTX(CommonFileType.DOCUMENT), XLSX(CommonFileType.DOCUMENT),
    JPEG(CommonFileType.IMAGE), JPG(CommonFileType.IMAGE), PNG(CommonFileType.IMAGE), GIF(CommonFileType.IMAGE),
    VOICE(CommonFileType.AUDIO), UNKNOWN(CommonFileType.NOT_SUPPORTED);

    private CommonFileType mCommonFileType;

    FileSharingType(CommonFileType commonFileType) {
        this.mCommonFileType = commonFileType;
    }

    public CommonFileType getCommonFileType() {
        return mCommonFileType;
    }

    public static FileSharingType getFileTypeFromMimeType(String mimeType) {
        try {
            MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
            String extension = mimeTypeMap.getExtensionFromMimeType(mimeType);
            return getFileTypeFromExtension(extension);
        } catch (Throwable throwable) {
            return UNKNOWN;
        }
    }

    public static FileSharingType getFileTypeFromExtension(String extension) {
        switch (extension) {
            case "pdf":
                return PDF;
            case "docx":
                return DOCX;
            case "pptx":
                return PPTX;
            case "xlsx":
                return XLSX;
            case "jpeg":
                return JPEG;
            case "jpg":
                return JPG;
            case "png":
                return PNG;
            case "gif":
                return GIF;
            default:
                return UNKNOWN;
        }
    }

    public enum CommonFileType {
        IMAGE,//common for JPEG,JPG,PNG,GIF
        DOCUMENT,//common for PDF,DOCX,PPTX,XLSX
        AUDIO, //common for VOICE
        NOT_SUPPORTED
    }
}
